/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.aggregation;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.aggregation.BaseIncrementalValueStore;
import io.siddhi.core.aggregation.Executor;
import io.siddhi.core.aggregation.IncrementalExecutor;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.OnDemandQueryRuntime;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.IncrementalTimeConverterUtil;
import io.siddhi.core.util.parser.OnDemandQueryParser;
import io.siddhi.core.util.snapshot.state.SingleSyncStateHolder;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.core.window.Window;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.execution.query.OnDemandQuery;
import io.siddhi.query.api.execution.query.input.store.InputStore;
import io.siddhi.query.api.execution.query.selection.OrderByAttribute;
import io.siddhi.query.api.execution.query.selection.Selector;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.expression.constant.Constant;
import java.util.List;
import java.util.Map;

public class IncrementalExecutorsInitialiser {
    private final List<TimePeriod.Duration> incrementalDurations;
    private final Map<TimePeriod.Duration, Table> aggregationTables;
    private final Map<TimePeriod.Duration, Executor> incrementalExecutorMap;
    private final boolean isDistributed;
    private final String shardId;
    private final StreamEventFactory streamEventFactory;
    private final SiddhiAppContext siddhiAppContext;
    private final Map<String, Table> tableMap;
    private final Map<String, Window> windowMap;
    private final Map<String, AggregationRuntime> aggregationMap;
    private String timeZone;
    private Long endOFLatestEventTimestamp = null;
    private boolean isInitialised;
    private boolean isReadOnly;
    private boolean isPersistedAggregation;

    public IncrementalExecutorsInitialiser(List<TimePeriod.Duration> incrementalDurations, Map<TimePeriod.Duration, Table> aggregationTables, Map<TimePeriod.Duration, Executor> incrementalExecutorMap, boolean isDistributed, String shardId, SiddhiAppContext siddhiAppContext, MetaStreamEvent metaStreamEvent, Map<String, Table> tableMap, Map<String, Window> windowMap, Map<String, AggregationRuntime> aggregationMap, String timeZone, boolean isReadOnly, boolean isPersistedAggregation) {
        this.timeZone = timeZone;
        this.incrementalDurations = incrementalDurations;
        this.aggregationTables = aggregationTables;
        this.incrementalExecutorMap = incrementalExecutorMap;
        this.isDistributed = isDistributed;
        this.shardId = shardId;
        this.streamEventFactory = new StreamEventFactory(metaStreamEvent);
        this.siddhiAppContext = siddhiAppContext;
        this.tableMap = tableMap;
        this.windowMap = windowMap;
        this.aggregationMap = aggregationMap;
        this.isInitialised = false;
        this.isReadOnly = isReadOnly;
        this.isPersistedAggregation = isPersistedAggregation;
    }

    public synchronized void initialiseExecutors() {
        if (this.isInitialised || this.isReadOnly) {
            return;
        }
        Long lastData = null;
        Table tableForMaxDuration = this.aggregationTables.get(this.incrementalDurations.get(this.incrementalDurations.size() - 1));
        OnDemandQuery onDemandQuery = this.getOnDemandQuery(tableForMaxDuration, true, this.endOFLatestEventTimestamp);
        onDemandQuery.setType(OnDemandQuery.OnDemandQueryType.FIND);
        OnDemandQueryRuntime onDemandQueryRuntime = OnDemandQueryParser.parse(onDemandQuery, null, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
        Event[] events = onDemandQueryRuntime.execute();
        if (events != null) {
            lastData = (Long)events[events.length - 1].getData(0);
            this.endOFLatestEventTimestamp = IncrementalTimeConverterUtil.getNextEmitTime(lastData, this.incrementalDurations.get(this.incrementalDurations.size() - 1), this.timeZone);
        }
        if (this.isPersistedAggregation) {
            for (int i = this.incrementalDurations.size() - 1; i > 0; --i) {
                if (lastData != null && !IncrementalTimeConverterUtil.isAggregationDataComplete(lastData, this.incrementalDurations.get(i), this.timeZone)) {
                    this.recreateState(lastData, this.incrementalDurations.get(i), this.aggregationTables.get(this.incrementalDurations.get(i - 1)), i == 1);
                } else if (lastData == null) {
                    this.recreateState(null, this.incrementalDurations.get(i), this.aggregationTables.get(this.incrementalDurations.get(i - 1)), i == 1);
                }
                if (i <= 1) continue;
                onDemandQuery = this.getOnDemandQuery(this.aggregationTables.get(this.incrementalDurations.get(i - 1)), true, this.endOFLatestEventTimestamp);
                onDemandQuery.setType(OnDemandQuery.OnDemandQueryType.FIND);
                onDemandQueryRuntime = OnDemandQueryParser.parse(onDemandQuery, null, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
                events = onDemandQueryRuntime.execute();
                lastData = events != null ? (Long)events[events.length - 1].getData(0) : null;
            }
        } else {
            for (int i = this.incrementalDurations.size() - 1; i > 0; --i) {
                Table recreateFromTable = this.aggregationTables.get(this.incrementalDurations.get(i - 1));
                onDemandQuery = this.getOnDemandQuery(recreateFromTable, false, this.endOFLatestEventTimestamp);
                onDemandQuery.setType(OnDemandQuery.OnDemandQueryType.FIND);
                onDemandQueryRuntime = OnDemandQueryParser.parse(onDemandQuery, null, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
                events = onDemandQueryRuntime.execute();
                if (events == null) continue;
                long referenceToNextLatestEvent = (Long)events[events.length - 1].getData(0);
                this.endOFLatestEventTimestamp = IncrementalTimeConverterUtil.getNextEmitTime(referenceToNextLatestEvent, this.incrementalDurations.get(i - 1), this.timeZone);
                TimePeriod.Duration recreateForDuration = this.incrementalDurations.get(i);
                if (!this.isStatePresentForAggregationDuration(recreateForDuration)) {
                    ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>();
                    for (Event event : events) {
                        StreamEvent streamEvent = this.streamEventFactory.newInstance();
                        streamEvent.setOutputData(event.getData());
                        complexEventChunk.add(streamEvent);
                    }
                    Executor incrementalExecutor = this.incrementalExecutorMap.get(recreateForDuration);
                    incrementalExecutor.execute(complexEventChunk);
                }
                if (i != 1) continue;
                TimePeriod.Duration rootDuration = this.incrementalDurations.get(0);
                Executor rootIncrementalExecutor = this.incrementalExecutorMap.get(rootDuration);
                long emitTimeOfLatestEventInTable = IncrementalTimeConverterUtil.getNextEmitTime(referenceToNextLatestEvent, rootDuration, this.timeZone);
                rootIncrementalExecutor.setEmitTime(emitTimeOfLatestEventInTable);
            }
        }
        this.isInitialised = true;
    }

    private boolean isStatePresentForAggregationDuration(TimePeriod.Duration recreateForDuration) {
        IncrementalExecutor incrementalExecutor = (IncrementalExecutor)this.incrementalExecutorMap.get(recreateForDuration);
        BaseIncrementalValueStore baseIncrementalValueStore = incrementalExecutor.getBaseIncrementalValueStore();
        StateHolder<BaseIncrementalValueStore.StoreState> storeStateHolder = baseIncrementalValueStore.getStoreStateHolder();
        return storeStateHolder instanceof SingleSyncStateHolder && ((SingleSyncStateHolder)storeStateHolder).isStatePresent();
    }

    private void recreateState(Long lastData, TimePeriod.Duration recreateForDuration, Table recreateFromTable, boolean isBeforeRoot) {
        if (lastData != null) {
            this.endOFLatestEventTimestamp = IncrementalTimeConverterUtil.getNextEmitTime(lastData, recreateForDuration, this.timeZone);
        }
        OnDemandQuery onDemandQuery = this.getOnDemandQuery(recreateFromTable, false, this.endOFLatestEventTimestamp);
        onDemandQuery.setType(OnDemandQuery.OnDemandQueryType.FIND);
        OnDemandQueryRuntime onDemandQueryRuntime = OnDemandQueryParser.parse(onDemandQuery, null, this.siddhiAppContext, this.tableMap, this.windowMap, this.aggregationMap);
        Event[] events = onDemandQueryRuntime.execute();
        if (events != null) {
            long referenceToNextLatestEvent = (Long)events[events.length - 1].getData(0);
            if (!this.isStatePresentForAggregationDuration(recreateForDuration)) {
                ComplexEventChunk<StreamEvent> complexEventChunk = new ComplexEventChunk<StreamEvent>();
                for (Event event : events) {
                    StreamEvent streamEvent = this.streamEventFactory.newInstance();
                    streamEvent.setOutputData(event.getData());
                    complexEventChunk.add(streamEvent);
                }
                Executor incrementalExecutor = this.incrementalExecutorMap.get(recreateForDuration);
                incrementalExecutor.execute(complexEventChunk);
            }
            if (isBeforeRoot) {
                TimePeriod.Duration rootDuration = this.incrementalDurations.get(0);
                Executor rootIncrementalExecutor = this.incrementalExecutorMap.get(rootDuration);
                long emitTimeOfLatestEventInTable = IncrementalTimeConverterUtil.getNextEmitTime(referenceToNextLatestEvent, rootDuration, this.timeZone);
                rootIncrementalExecutor.setEmitTime(emitTimeOfLatestEventInTable);
            }
        }
    }

    private OnDemandQuery getOnDemandQuery(Table table, boolean isLargestGranularity, Long endOFLatestEventTimestamp) {
        Selector selector = Selector.selector();
        selector = isLargestGranularity ? selector.orderBy(Expression.variable((String)"AGG_TIMESTAMP"), OrderByAttribute.Order.DESC).limit((Constant)Expression.value((int)1)) : selector.orderBy(Expression.variable((String)"AGG_TIMESTAMP"));
        Object inputStore = !this.isDistributed ? (endOFLatestEventTimestamp == null ? InputStore.store((String)table.getTableDefinition().getId()) : InputStore.store((String)table.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.value((long)endOFLatestEventTimestamp)))) : (endOFLatestEventTimestamp == null ? InputStore.store((String)table.getTableDefinition().getId()).on(Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId))) : InputStore.store((String)table.getTableDefinition().getId()).on(Expression.and((Expression)Expression.compare((Expression)Expression.variable((String)"SHARD_ID"), (Compare.Operator)Compare.Operator.EQUAL, (Expression)Expression.value((String)this.shardId)), (Expression)Expression.compare((Expression)Expression.variable((String)"AGG_TIMESTAMP"), (Compare.Operator)Compare.Operator.GREATER_THAN_EQUAL, (Expression)Expression.value((long)endOFLatestEventTimestamp)))));
        return OnDemandQuery.query().from((InputStore)inputStore).select(selector);
    }
}

