/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.function;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.UUID;

@Extension(name="UUID", namespace="", description="Generates a UUID (Universally Unique Identifier).", parameters={}, parameterOverloads={@ParameterOverload}, returnAttributes={@ReturnAttribute(description="Returns a UUID string.", type={DataType.STRING})}, examples={@Example(syntax="from TempStream\nselect convert(roomNo, 'string') as roomNo, temp, UUID() as messageID\ninsert into RoomTempStream;", description="This will converts a room number to string, introducing a message ID to each event asUUID() returns a34eec40-32c2-44fe-8075-7f4fde2e2dd8\n\nfrom TempStream\nselect convert(roomNo, 'string') as roomNo, temp, UUID() as messageID\ninsert into RoomTempStream;")})
public class UUIDFunctionExecutor
extends FunctionExecutor {
    Attribute.Type returnType = Attribute.Type.STRING;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        return null;
    }

    protected Object execute(Object[] data, State state) {
        return null;
    }

    protected Object execute(Object data, State state) {
        return UUID.randomUUID().toString();
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

