/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.record;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.exception.DatabaseRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.CompiledUpdateSet;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.ExpressionBuilder;
import io.siddhi.core.table.record.RecordIterator;
import io.siddhi.core.table.record.RecordStoreCompiledCondition;
import io.siddhi.core.table.record.RecordTableCompiledUpdateSet;
import io.siddhi.core.table.record.RecordTableHandler;
import io.siddhi.core.table.record.RecordTableHandlerCallback;
import io.siddhi.core.table.record.UpdateOrInsertReducer;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledExpression;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.transport.DynamicOptions;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import io.siddhi.query.api.expression.Expression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractRecordTable
extends Table {
    private static final Logger log = LogManager.getLogger(AbstractRecordTable.class);
    protected StreamEventFactory storeEventPool;
    protected RecordTableHandler recordTableHandler;
    private ThreadLocal<DynamicOptions> trpDynamicOptions;

    @Override
    public void init(TableDefinition tableDefinition, StreamEventFactory storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler) {
        if (recordTableHandler != null) {
            recordTableHandler.init(tableDefinition, new RecordTableHandlerCallback(this), siddhiAppContext);
        }
        this.recordTableHandler = recordTableHandler;
        this.storeEventPool = storeEventPool;
        this.init(tableDefinition, configReader);
        this.initCache(tableDefinition, siddhiAppContext, storeEventCloner, configReader);
    }

    protected void initCache(TableDefinition tableDefinition, SiddhiAppContext siddhiAppContext, StreamEventCloner storeEventCloner, ConfigReader configReader) {
    }

    protected abstract void init(TableDefinition var1, ConfigReader var2);

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        addingEventChunk.reset();
        long timestamp = 0L;
        while (addingEventChunk.hasNext()) {
            StreamEvent event = (StreamEvent)addingEventChunk.next();
            records.add(event.getOutputData());
            timestamp = event.getTimestamp();
        }
        try {
            if (this.recordTableHandler != null) {
                this.recordTableHandler.add(timestamp, records);
            } else {
                this.add(records);
            }
        }
        catch (ConnectionUnavailableException | DatabaseRuntimeException e) {
            this.onAddError(addingEventChunk, e);
        }
    }

    protected abstract void add(List<Object[]> var1) throws ConnectionUnavailableException;

    @Override
    public StreamEvent find(CompiledCondition compiledCondition, StateEvent matchingEvent) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        HashMap<String, Object> findConditionParameterMap = new HashMap<String, Object>();
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
            findConditionParameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        Iterator<Object[]> records = this.recordTableHandler != null ? this.recordTableHandler.find(matchingEvent.getTimestamp(), findConditionParameterMap, recordStoreCompiledCondition.getCompiledCondition()) : this.find(findConditionParameterMap, recordStoreCompiledCondition.getCompiledCondition());
        ComplexEventChunk<StreamEvent> streamEventComplexEventChunk = new ComplexEventChunk<StreamEvent>();
        if (records != null) {
            while (records.hasNext()) {
                Object[] record = records.next();
                StreamEvent streamEvent = this.storeEventPool.newInstance();
                System.arraycopy(record, 0, streamEvent.getOutputData(), 0, record.length);
                streamEventComplexEventChunk.add(streamEvent);
            }
        }
        return (StreamEvent)streamEventComplexEventChunk.getFirst();
    }

    protected abstract RecordIterator<Object[]> find(Map<String, Object> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    @Override
    public boolean contains(StateEvent matchingEvent, CompiledCondition compiledCondition) throws ConnectionUnavailableException {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        HashMap<String, Object> containsConditionParameterMap = new HashMap<String, Object>();
        for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
            containsConditionParameterMap.put(entry.getKey(), entry.getValue().execute(matchingEvent));
        }
        if (this.recordTableHandler != null) {
            return this.recordTableHandler.contains(matchingEvent.getTimestamp(), containsConditionParameterMap, recordStoreCompiledCondition.getCompiledCondition());
        }
        return this.contains(containsConditionParameterMap, recordStoreCompiledCondition.getCompiledCondition());
    }

    protected abstract boolean contains(Map<String, Object> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition) {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        ArrayList<Map<String, Object>> deleteConditionParameterMaps = new ArrayList<Map<String, Object>>();
        deletingEventChunk.reset();
        long timestamp = 0L;
        while (deletingEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)deletingEventChunk.next();
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
                variableMap.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            deleteConditionParameterMaps.add(variableMap);
            timestamp = stateEvent.getTimestamp();
        }
        try {
            if (this.recordTableHandler != null) {
                this.recordTableHandler.delete(timestamp, deleteConditionParameterMaps, recordStoreCompiledCondition.getCompiledCondition());
            } else {
                this.delete(deleteConditionParameterMaps, recordStoreCompiledCondition.getCompiledCondition());
            }
        }
        catch (ConnectionUnavailableException | DatabaseRuntimeException e) {
            this.onDeleteError(deletingEventChunk, compiledCondition, e);
        }
    }

    @Override
    protected void connectAndLoadCache() throws ConnectionUnavailableException {
        this.connect();
    }

    protected abstract void connect() throws ConnectionUnavailableException;

    protected abstract void delete(List<Map<String, Object>> var1, CompiledCondition var2) throws ConnectionUnavailableException;

    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet) {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = (RecordTableCompiledUpdateSet)compiledUpdateSet;
        ArrayList<Map<String, Object>> updateConditionParameterMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateSetParameterMaps = new ArrayList<Map<String, Object>>();
        updatingEventChunk.reset();
        long timestamp = 0L;
        while (updatingEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)updatingEventChunk.next();
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
                variableMap.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateConditionParameterMaps.add(variableMap);
            HashMap<String, Object> variableMapForUpdateSet = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordTableCompiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                variableMapForUpdateSet.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateSetParameterMaps.add(variableMapForUpdateSet);
            timestamp = stateEvent.getTimestamp();
        }
        try {
            if (this.recordTableHandler != null) {
                this.recordTableHandler.update(timestamp, recordStoreCompiledCondition.getCompiledCondition(), updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps);
            } else {
                this.update(recordStoreCompiledCondition.getCompiledCondition(), updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps);
            }
        }
        catch (ConnectionUnavailableException | DatabaseRuntimeException e) {
            this.onUpdateError(updatingEventChunk, compiledCondition, compiledUpdateSet, e);
        }
    }

    protected abstract void update(CompiledCondition var1, List<Map<String, Object>> var2, Map<String, CompiledExpression> var3, List<Map<String, Object>> var4) throws ConnectionUnavailableException;

    @Override
    public void updateOrAdd(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        RecordStoreCompiledCondition recordStoreCompiledCondition = (RecordStoreCompiledCondition)compiledCondition;
        RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = (RecordTableCompiledUpdateSet)compiledUpdateSet;
        ArrayList<Map<String, Object>> updateConditionParameterMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> updateSetParameterMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Object[]> addingRecords = new ArrayList<Object[]>();
        updateOrAddingEventChunk.reset();
        long timestamp = 0L;
        while (updateOrAddingEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)updateOrAddingEventChunk.next();
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordStoreCompiledCondition.variableExpressionExecutorMap.entrySet()) {
                variableMap.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateConditionParameterMaps.add(variableMap);
            HashMap<String, Object> variableMapForUpdateSet = new HashMap<String, Object>();
            for (Map.Entry<String, ExpressionExecutor> entry : recordTableCompiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                variableMapForUpdateSet.put(entry.getKey(), entry.getValue().execute(stateEvent));
            }
            updateSetParameterMaps.add(variableMapForUpdateSet);
            addingRecords.add(stateEvent.getStreamEvent(0).getOutputData());
            timestamp = stateEvent.getTimestamp();
        }
        try {
            if (this.recordTableHandler != null) {
                this.recordTableHandler.updateOrAdd(timestamp, recordStoreCompiledCondition.getCompiledCondition(), updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps, addingRecords);
            } else {
                this.updateOrAdd(recordStoreCompiledCondition.getCompiledCondition(), updateConditionParameterMaps, recordTableCompiledUpdateSet.getUpdateSetMap(), updateSetParameterMaps, addingRecords);
            }
        }
        catch (ConnectionUnavailableException | DatabaseRuntimeException e) {
            this.onUpdateOrAddError(updateOrAddingEventChunk, compiledCondition, compiledUpdateSet, addingStreamEventExtractor, e);
        }
    }

    protected abstract void updateOrAdd(CompiledCondition var1, List<Map<String, Object>> var2, Map<String, CompiledExpression> var3, List<Map<String, Object>> var4, List<Object[]> var5) throws ConnectionUnavailableException;

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        ExpressionExecutor inMemoryCompiledCondition = ExpressionParser.parseExpression(condition, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, new UpdateOrInsertReducer(inMemoryCompiledCondition, matchingMetaInfoHolder), null, siddhiQueryContext);
        CompiledCondition compileCondition = this.compileCondition(expressionBuilder);
        Map<String, ExpressionExecutor> expressionExecutorMap = expressionBuilder.getVariableExpressionExecutorMap();
        return new RecordStoreCompiledCondition(expressionExecutorMap, compileCondition, siddhiQueryContext);
    }

    @Override
    public CompiledUpdateSet compileUpdateSet(UpdateSet updateSet, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        RecordTableCompiledUpdateSet recordTableCompiledUpdateSet = new RecordTableCompiledUpdateSet();
        HashMap<String, ExpressionExecutor> parentExecutorMap = new HashMap<String, ExpressionExecutor>();
        for (UpdateSet.SetAttribute setAttribute : updateSet.getSetAttributeList()) {
            ExpressionExecutor inMemoryAssignmentExecutor = ExpressionParser.parseExpression(setAttribute.getAssignmentExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            ExpressionBuilder expressionBuilder = new ExpressionBuilder(setAttribute.getAssignmentExpression(), matchingMetaInfoHolder, variableExpressionExecutors, tableMap, null, inMemoryAssignmentExecutor, siddhiQueryContext);
            CompiledExpression compiledExpression = this.compileSetAttribute(expressionBuilder);
            recordTableCompiledUpdateSet.put(setAttribute.getTableVariable().getAttributeName(), compiledExpression);
            Map<String, ExpressionExecutor> expressionExecutorMap = expressionBuilder.getVariableExpressionExecutorMap();
            parentExecutorMap.putAll(expressionExecutorMap);
        }
        recordTableCompiledUpdateSet.setExpressionExecutorMap(parentExecutorMap);
        return recordTableCompiledUpdateSet;
    }

    protected abstract CompiledCondition compileCondition(ExpressionBuilder var1);

    protected abstract CompiledExpression compileSetAttribute(ExpressionBuilder var1);

    @Override
    public boolean isStateful() {
        return false;
    }
}

