/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.annotation.Extension;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.executor.incremental.IncrementalAggregateBaseTimeFunctionExecutor;
import io.siddhi.core.executor.incremental.IncrementalShouldUpdateFunctionExecutor;
import io.siddhi.core.executor.incremental.IncrementalStartTimeEndTimeFunctionExecutor;
import io.siddhi.core.executor.incremental.IncrementalTimeGetTimeZone;
import io.siddhi.core.executor.incremental.IncrementalUnixTimeFunctionExecutor;
import io.siddhi.core.function.Script;
import io.siddhi.core.query.processor.stream.StreamProcessor;
import io.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import io.siddhi.core.query.processor.stream.window.WindowProcessor;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.query.selector.attribute.aggregator.incremental.IncrementalAttributeAggregator;
import io.siddhi.core.stream.input.source.Source;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.core.stream.output.sink.SinkMapper;
import io.siddhi.core.stream.output.sink.distributed.DistributionStrategy;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.ReferenceHolder;
import io.siddhi.core.util.extension.holder.AbstractExtensionHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.atteo.classindex.ClassIndex;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.wiring.BundleWiring;

public class SiddhiExtensionLoader {
    private static final Logger log = LogManager.getLogger(SiddhiExtensionLoader.class);
    private static final Class ATTRIBUTE_AGGREGATOR_EXECUTOR_CLASS = AttributeAggregatorExecutor.class;
    private static final Class DISTRIBUTION_STRATEGY_CLASS = DistributionStrategy.class;
    private static final Class FUNCTION_EXECUTOR_CLASS = FunctionExecutor.class;
    private static final Class INCREMENTAL_ATTRIBUTE_AGGREGATOR_CLASS = IncrementalAttributeAggregator.class;
    private static final Class SCRIPT_CLASS = Script.class;
    private static final Class SINK_CLASS = Sink.class;
    private static final Class SINK_MAPPER_CLASS = SinkMapper.class;
    private static final Class SOURCE_CLASS = Source.class;
    private static final Class SOURCE_MAPPER_CLASS = SourceMapper.class;
    private static final Class STREAM_FUNCTION_PROCESSOR_CLASS = StreamFunctionProcessor.class;
    private static final Class STREAM_PROCESSOR_CLASS = StreamProcessor.class;
    private static final Class TABLE_CLASS = Table.class;
    private static final Class WINDOW_PROCESSOR_CLASS = WindowProcessor.class;
    private static List<Class> extensionNameSpaceList = new ArrayList<Class>();

    public static void loadSiddhiExtensions(Map<String, Class> siddhiExtensionsMap, ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderMap, Map<String, Class> deprecatedSiddhiExtensionsMap) {
        SiddhiExtensionLoader.loadLocalExtensions(siddhiExtensionsMap, extensionHolderMap, deprecatedSiddhiExtensionsMap);
        BundleContext bundleContext = ReferenceHolder.getInstance().getBundleContext();
        if (bundleContext != null) {
            SiddhiExtensionLoader.loadExtensionOSGI(bundleContext, siddhiExtensionsMap, extensionHolderMap, deprecatedSiddhiExtensionsMap);
        }
    }

    private static void loadExtensionOSGI(BundleContext bundleContext, Map<String, Class> siddhiExtensionsMap, ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderMap, Map<String, Class> deprecatedSiddhiExtensionsMap) {
        ExtensionBundleListener extensionBundleListener = new ExtensionBundleListener(siddhiExtensionsMap, extensionHolderMap, deprecatedSiddhiExtensionsMap);
        bundleContext.addBundleListener((BundleListener)extensionBundleListener);
        extensionBundleListener.loadAllExtensions(bundleContext);
    }

    private static void loadLocalExtensions(Map<String, Class> siddhiExtensionsMap, ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderMap, Map<String, Class> deprecatedSiddhiExtensionsMap) {
        Iterable extensions = ClassIndex.getAnnotated(Extension.class);
        for (Class extension : extensions) {
            SiddhiExtensionLoader.addExtensionToMap(extension, siddhiExtensionsMap, extensionHolderMap, deprecatedSiddhiExtensionsMap);
        }
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:startTimeEndTime", IncrementalStartTimeEndTimeFunctionExecutor.class, siddhiExtensionsMap);
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:timestampInMilliseconds", IncrementalUnixTimeFunctionExecutor.class, siddhiExtensionsMap);
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:getTimeZone", IncrementalTimeGetTimeZone.class, siddhiExtensionsMap);
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:getAggregationStartTime", IncrementalAggregateBaseTimeFunctionExecutor.class, siddhiExtensionsMap);
        SiddhiExtensionLoader.addExtensionToMap("incrementalAggregator:shouldUpdate", IncrementalShouldUpdateFunctionExecutor.class, siddhiExtensionsMap);
    }

    private static void addExtensionToMap(Class extensionClass, Map<String, Class> siddhiExtensionsMap, ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderMap, Map<String, Class> deprecatedSiddhiExtensionsMap) {
        Extension siddhiExtensionAnnotation = extensionClass.getAnnotation(Extension.class);
        if (siddhiExtensionAnnotation != null) {
            if (!siddhiExtensionAnnotation.name().isEmpty()) {
                Class previousClass = null;
                if (!siddhiExtensionAnnotation.namespace().isEmpty()) {
                    String key = siddhiExtensionAnnotation.namespace() + ":" + siddhiExtensionAnnotation.name();
                    Class existingValue = siddhiExtensionsMap.get(key);
                    if (existingValue == null) {
                        previousClass = siddhiExtensionsMap.put(key, extensionClass);
                        if (siddhiExtensionAnnotation.deprecated()) {
                            deprecatedSiddhiExtensionsMap.put(key, extensionClass);
                        }
                        for (Class clazz : extensionNameSpaceList) {
                            SiddhiExtensionLoader.putToExtensionHolderMap(clazz, extensionClass, key, extensionHolderMap);
                        }
                    }
                    if (previousClass != null) {
                        log.warn("Dropping extension '" + previousClass + "' as '" + extensionClass + "' is loaded with the same namespace and name '" + siddhiExtensionAnnotation.namespace() + ":" + siddhiExtensionAnnotation.name() + "'");
                    }
                } else {
                    previousClass = siddhiExtensionsMap.put(siddhiExtensionAnnotation.name(), extensionClass);
                    if (siddhiExtensionAnnotation.deprecated()) {
                        deprecatedSiddhiExtensionsMap.put(siddhiExtensionAnnotation.name(), extensionClass);
                    }
                    if (previousClass != null) {
                        log.warn("Dropping extension '" + previousClass + "' as '" + extensionClass + "' is loaded with the same name '" + siddhiExtensionAnnotation.name() + "'");
                    }
                }
            } else {
                log.error("Unable to load extension " + extensionClass.getName() + ", missing Extension annotation.");
            }
        } else {
            log.error("Unable to load extension " + extensionClass.getName() + ", empty name element given in Extension annotation.");
        }
    }

    private static void putToExtensionHolderMap(Class extensionSuperClass, Class extension, String extensionKey, ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderConcurrentHashMap) {
        AbstractExtensionHolder extensionHolder;
        if (extensionSuperClass.isAssignableFrom(extension) && (extensionHolder = extensionHolderConcurrentHashMap.get(extensionSuperClass)) != null) {
            if (extensionHolder.getExtension(extensionKey) != null) {
                log.error("Extension class " + extension.getName() + " not loaded, as there is already an matching extension '" + extensionKey + "' implemented as " + extensionHolder.getExtension(extensionKey).getName());
            } else {
                extensionHolder.addExtension(extensionKey, extension);
            }
        }
    }

    private static void removeFromExtensionHolderMap(String extensionKey, Class extension, ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderConcurrentHashMap) {
        for (Class extensionSuperClass : extensionNameSpaceList) {
            AbstractExtensionHolder extensionHolder;
            if (!extensionSuperClass.isAssignableFrom(extension) || (extensionHolder = extensionHolderConcurrentHashMap.get(extensionSuperClass)) == null) continue;
            extensionHolder.removeExtension(extensionKey);
        }
    }

    private static void addExtensionToMap(String fqExtensionName, Class extensionClass, Map<String, Class> siddhiExtensionsMap) {
        Class previousClass = null;
        Class existingValue = siddhiExtensionsMap.get(fqExtensionName);
        if (existingValue == null) {
            previousClass = siddhiExtensionsMap.put(fqExtensionName, extensionClass);
        }
        if (previousClass != null) {
            log.warn("Dropping extension '" + extensionClass + "' as '" + previousClass + "' was already loaded with the same namespace and name '" + fqExtensionName + "'");
        }
    }

    static {
        extensionNameSpaceList.add(DISTRIBUTION_STRATEGY_CLASS);
        extensionNameSpaceList.add(SCRIPT_CLASS);
        extensionNameSpaceList.add(SINK_CLASS);
        extensionNameSpaceList.add(SINK_MAPPER_CLASS);
        extensionNameSpaceList.add(SOURCE_CLASS);
        extensionNameSpaceList.add(SOURCE_MAPPER_CLASS);
        extensionNameSpaceList.add(TABLE_CLASS);
        extensionNameSpaceList.add(ATTRIBUTE_AGGREGATOR_EXECUTOR_CLASS);
        extensionNameSpaceList.add(FUNCTION_EXECUTOR_CLASS);
        extensionNameSpaceList.add(INCREMENTAL_ATTRIBUTE_AGGREGATOR_CLASS);
        extensionNameSpaceList.add(STREAM_FUNCTION_PROCESSOR_CLASS);
        extensionNameSpaceList.add(STREAM_PROCESSOR_CLASS);
        extensionNameSpaceList.add(WINDOW_PROCESSOR_CLASS);
    }

    private static class ExtensionBundleListener
    implements BundleListener {
        private Map<Class, Integer> bundleExtensions = new HashMap<Class, Integer>();
        private Map<String, Class> siddhiExtensionsMap;
        private Map<String, Class> deprecatedSiddhiExtensionsMap;
        private ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderConcurrentHashMap;

        ExtensionBundleListener(Map<String, Class> siddhiExtensionsMap, ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderConcurrentHashMap, Map<String, Class> deprecatedSiddhiExtensionsMap) {
            this.siddhiExtensionsMap = siddhiExtensionsMap;
            this.extensionHolderConcurrentHashMap = extensionHolderConcurrentHashMap;
            this.deprecatedSiddhiExtensionsMap = deprecatedSiddhiExtensionsMap;
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getType() == 2) {
                this.addExtensions(bundleEvent.getBundle());
            } else {
                this.removeExtensions(bundleEvent.getBundle());
            }
        }

        private void addExtensions(Bundle bundle) {
            ClassLoader classLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            Iterable extensions = ClassIndex.getAnnotated(Extension.class, (ClassLoader)classLoader);
            for (Class extension : extensions) {
                SiddhiExtensionLoader.addExtensionToMap(extension, this.siddhiExtensionsMap, this.extensionHolderConcurrentHashMap, this.deprecatedSiddhiExtensionsMap);
                this.bundleExtensions.put(extension, (int)bundle.getBundleId());
            }
        }

        private void removeExtensions(Bundle bundle) {
            this.bundleExtensions.entrySet().stream().filter(entry -> (long)((Integer)entry.getValue()).intValue() == bundle.getBundleId()).forEachOrdered(entry -> this.siddhiExtensionsMap.remove(entry.getKey()));
            this.bundleExtensions.entrySet().removeIf(entry -> (long)((Integer)entry.getValue()).intValue() == bundle.getBundleId());
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (bundleWiring != null) {
                ClassLoader classLoader = bundleWiring.getClassLoader();
                Iterable extensions = ClassIndex.getAnnotated(Extension.class, (ClassLoader)classLoader);
                for (Class extension : extensions) {
                    Extension siddhiExtensionAnnotation = extension.getAnnotation(Extension.class);
                    if (siddhiExtensionAnnotation.namespace().isEmpty()) continue;
                    String key = siddhiExtensionAnnotation.namespace() + ":" + siddhiExtensionAnnotation.name();
                    SiddhiExtensionLoader.removeFromExtensionHolderMap(key, extension, this.extensionHolderConcurrentHashMap);
                }
            }
        }

        void loadAllExtensions(BundleContext bundleContext) {
            for (Bundle b : bundleContext.getBundles()) {
                if (b.getState() != 32) continue;
                this.addExtensions(b);
            }
        }
    }
}

