/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.snapshot.state;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionStateHolder
implements StateHolder {
    private static final Logger log = LogManager.getLogger(PartitionStateHolder.class);
    private StateFactory stateFactory;
    private Map<String, Map<String, State>> states = new HashMap<String, Map<String, State>>();

    public PartitionStateHolder(StateFactory stateFactory) {
        this.stateFactory = stateFactory;
    }

    public State getState() {
        String partitionFlowId = SiddhiAppContext.getPartitionFlowId();
        String groupByFlowId = SiddhiAppContext.getGroupByFlowId();
        Map partitionStates = this.states.computeIfAbsent(partitionFlowId, k -> new HashMap());
        return partitionStates.computeIfAbsent(groupByFlowId, s -> this.stateFactory.createNewState());
    }

    public void returnState(State state) {
        String partitionFlowId = SiddhiAppContext.getPartitionFlowId();
        String groupByFlowId = SiddhiAppContext.getGroupByFlowId();
        if (state.activeUseCount == 0) {
            try {
                if (state.canDestroy()) {
                    this.removeState(partitionFlowId, groupByFlowId);
                }
            }
            catch (Throwable t) {
                log.error("Dropping partition state for partition key '" + partitionFlowId + "' and the group by key '" + groupByFlowId + "', due to error! " + t.getMessage(), t);
                this.removeState(partitionFlowId, groupByFlowId);
            }
        } else if (state.activeUseCount < 0) {
            throw new SiddhiAppRuntimeException("State active count has reached less then zero for partition key '" + partitionFlowId + "' and the group by key '" + groupByFlowId + "', current value is " + state.activeUseCount);
        }
    }

    private void removeState(String partitionFlowId, String groupByFlowId) {
        Map<String, State> groupByStates = this.states.get(partitionFlowId);
        if (groupByStates != null) {
            groupByStates.remove(groupByFlowId);
            if (groupByStates.isEmpty()) {
                this.states.remove(partitionFlowId);
            }
        }
    }

    public Map<String, Map<String, State>> getAllStates() {
        return this.states;
    }

    public Map<String, State> getAllGroupByStates() {
        String partitionFlowId = SiddhiAppContext.getPartitionFlowId();
        return this.states.computeIfAbsent(partitionFlowId, k -> new HashMap());
    }

    public State cleanGroupByStates() {
        String partitionFlowId = SiddhiAppContext.getPartitionFlowId();
        Map<String, State> groupByStates = this.states.remove(partitionFlowId);
        if (groupByStates != null) {
            return groupByStates.values().stream().findFirst().orElse(null);
        }
        return null;
    }

    public void returnGroupByStates(Map states) {
        String partitionFlowId = SiddhiAppContext.getPartitionFlowId();
        Iterator iterator = states.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry stateEntry = iterator.next();
            State state = (State)stateEntry.getValue();
            if (state.activeUseCount == 0) {
                try {
                    if (!state.canDestroy()) continue;
                    iterator.remove();
                }
                catch (Throwable t) {
                    log.error("Dropping partition state for partition key '" + partitionFlowId + "' and the group by key '" + (String)stateEntry.getKey() + "', due to error! " + t.getMessage(), t);
                    iterator.remove();
                }
                continue;
            }
            if (state.activeUseCount >= 0) continue;
            throw new SiddhiAppRuntimeException("State active count has reached less then zero for partition key '" + partitionFlowId + "' and the group by key '" + (String)stateEntry.getKey() + "', current value is " + state.activeUseCount);
        }
        if (states.isEmpty()) {
            states.remove(partitionFlowId);
        }
    }

    public void returnAllStates(Map states) {
        Iterator statesIterator = states.entrySet().iterator();
        while (statesIterator.hasNext()) {
            Map.Entry statesEntry = statesIterator.next();
            Iterator stateIterator = ((Map)statesEntry.getValue()).entrySet().iterator();
            while (stateIterator.hasNext()) {
                Map.Entry stateEntry = stateIterator.next();
                State state = (State)stateEntry.getValue();
                if (state.activeUseCount == 0) {
                    try {
                        if (!state.canDestroy()) continue;
                        stateIterator.remove();
                    }
                    catch (Throwable t) {
                        log.error("Dropping partition state for partition key '" + (String)statesEntry.getKey() + "' and the group by key '" + (String)stateEntry.getKey() + "', due to error! " + t.getMessage(), t);
                        stateIterator.remove();
                    }
                    continue;
                }
                if (state.activeUseCount >= 0) continue;
                throw new SiddhiAppRuntimeException("State active count has reached less then zero for partition key '" + (String)statesEntry.getKey() + "' and the group by key '" + (String)stateEntry.getKey() + "', current value is " + state.activeUseCount);
            }
            if (!((Map)statesEntry.getValue()).isEmpty()) continue;
            statesIterator.remove();
        }
    }
}

