/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.callback;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.query.api.execution.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QueryCallback {
    private static final Logger log = LogManager.getLogger(QueryCallback.class);
    private SiddhiAppContext siddhiAppContext;
    private Query query;
    private String queryName;

    public void setQuery(Query query) {
        this.query = query;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setContext(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
    }

    public void receiveStreamEvent(ComplexEventChunk complexEventChunk) {
        Event[] currentEvents = null;
        Event[] expiredEvents = null;
        long timestamp = -1L;
        ArrayList<Event> currentEventBuffer = new ArrayList<Event>();
        ArrayList<Event> expiredEventBuffer = new ArrayList<Event>();
        complexEventChunk.reset();
        while (complexEventChunk.hasNext()) {
            Object streamEvent = complexEventChunk.next();
            if (streamEvent.getType() == ComplexEvent.Type.EXPIRED) {
                this.bufferEvent((ComplexEvent)streamEvent, expiredEventBuffer);
            } else if (streamEvent.getType() == ComplexEvent.Type.CURRENT) {
                this.bufferEvent((ComplexEvent)streamEvent, currentEventBuffer);
            }
            timestamp = streamEvent.getTimestamp();
        }
        if (!currentEventBuffer.isEmpty()) {
            currentEvents = currentEventBuffer.toArray(new Event[currentEventBuffer.size()]);
            currentEventBuffer.clear();
        }
        if (!expiredEventBuffer.isEmpty()) {
            expiredEvents = expiredEventBuffer.toArray(new Event[expiredEventBuffer.size()]);
            expiredEventBuffer.clear();
        }
        this.send(timestamp, currentEvents, expiredEvents);
    }

    private void send(long timestamp, Event[] currentEvents, Event[] expiredEvents) {
        try {
            this.receive(timestamp, currentEvents, expiredEvents);
        }
        catch (RuntimeException e) {
            log.error("Error on sending events" + Arrays.deepToString(currentEvents) + ", " + Arrays.deepToString(expiredEvents), (Throwable)e);
        }
    }

    private void bufferEvent(ComplexEvent complexEvent, List<Event> eventBuffer) {
        eventBuffer.add(new Event(complexEvent.getOutputData().length).copyFrom(complexEvent));
    }

    public abstract void receive(long var1, Event[] var3, Event[] var4);
}

