/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.error.handler.util;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.Event;
import io.siddhi.core.util.error.handler.model.ErroneousEvent;
import io.siddhi.core.util.error.handler.model.ReplayableTableRecord;
import io.siddhi.core.util.error.handler.store.ErrorStore;
import io.siddhi.core.util.error.handler.util.ErroneousEventType;
import io.siddhi.core.util.error.handler.util.ErrorOccurrence;
import io.siddhi.core.util.error.handler.util.ErrorType;
import java.util.List;

public class ErrorStoreHelper {
    private ErrorStoreHelper() {
    }

    public static void storeErroneousEvent(ErrorStore errorStore, ErrorOccurrence occurrence, String siddhiAppName, Object erroneousEvent, String streamName) {
        if (errorStore != null && erroneousEvent != null) {
            switch (ErrorStoreHelper.getErrorType(occurrence)) {
                case MAPPING: {
                    if (!(erroneousEvent instanceof List)) break;
                    errorStore.saveMappingError(siddhiAppName, (List)erroneousEvent, streamName);
                    break;
                }
                case TRANSPORT: {
                    errorStore.saveTransportError(siddhiAppName, (ErroneousEvent)erroneousEvent, ErrorStoreHelper.getErroneousEventType(((ErroneousEvent)erroneousEvent).getEvent()), streamName, occurrence);
                }
            }
        }
    }

    private static ErrorType getErrorType(ErrorOccurrence errorOccurrence) {
        if (errorOccurrence == ErrorOccurrence.BEFORE_SOURCE_MAPPING) {
            return ErrorType.MAPPING;
        }
        return ErrorType.TRANSPORT;
    }

    private static ErroneousEventType getErroneousEventType(Object event) {
        if (event instanceof ReplayableTableRecord) {
            return ErroneousEventType.REPLAYABLE_TABLE_RECORD;
        }
        if (event instanceof ComplexEvent) {
            return ErroneousEventType.COMPLEX_EVENT;
        }
        if (event instanceof Event) {
            return ErroneousEventType.EVENT;
        }
        if (event instanceof Event[]) {
            return ErroneousEventType.EVENT_ARRAY;
        }
        if (event instanceof List) {
            return ErroneousEventType.EVENT_LIST;
        }
        return ErroneousEventType.PAYLOAD_STRING;
    }
}

