/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.snapshot;

import io.siddhi.core.exception.NoPersistenceStoreException;
import io.siddhi.core.util.persistence.PersistenceStore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncSnapshotPersistor
implements Runnable {
    private static final Logger log = LogManager.getLogger(AsyncSnapshotPersistor.class);
    private byte[] snapshots;
    private PersistenceStore persistenceStore;
    private String siddhiAppName;
    private String revision;
    private long time;

    public AsyncSnapshotPersistor(byte[] snapshots, PersistenceStore persistenceStore, String siddhiAppName, long time) {
        if (persistenceStore == null) {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app '" + siddhiAppName + "'");
        }
        this.snapshots = snapshots;
        this.persistenceStore = persistenceStore;
        this.siddhiAppName = siddhiAppName;
        this.time = time;
        this.revision = time + "__" + siddhiAppName;
    }

    public String getRevision() {
        return this.revision;
    }

    @Override
    public void run() {
        if (this.persistenceStore != null) {
            if (log.isDebugEnabled()) {
                log.debug("Persisting...");
            }
            this.persistenceStore.save(this.siddhiAppName, this.revision, this.snapshots);
            if (log.isDebugEnabled()) {
                log.debug("Persisted.");
            }
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + this.siddhiAppName);
        }
    }
}

