/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.executor.incremental;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.function.FunctionExecutor;
import io.siddhi.core.util.IncrementalTimeConverterUtil;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.aggregation.TimePeriod;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;

public class IncrementalAggregateBaseTimeFunctionExecutor
extends FunctionExecutor {
    private String timeZone;

    protected StateFactory init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("incrementalAggregator:getAggregationStartTime() function accepts two arguments, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Second argument of incrementalAggregator:getAggregationStartTime() function accepts should be of type 'STRING', but found '" + attributeExpressionExecutors[1].getReturnType() + "'.");
        }
        this.timeZone = siddhiQueryContext.getSiddhiContext().getConfigManager().extractProperty("aggTimeZone");
        if (this.timeZone == null) {
            this.timeZone = "GMT";
        }
        return null;
    }

    protected Object execute(Object[] data, State state) {
        TimePeriod.Duration duration;
        String durationName;
        long time = (Long)data[0];
        switch (durationName = (String)data[1]) {
            case "SECONDS": {
                duration = TimePeriod.Duration.SECONDS;
                break;
            }
            case "MINUTES": {
                duration = TimePeriod.Duration.MINUTES;
                break;
            }
            case "HOURS": {
                duration = TimePeriod.Duration.HOURS;
                break;
            }
            case "DAYS": {
                duration = TimePeriod.Duration.DAYS;
                break;
            }
            case "MONTHS": {
                duration = TimePeriod.Duration.MONTHS;
                break;
            }
            case "YEARS": {
                duration = TimePeriod.Duration.YEARS;
                break;
            }
            default: {
                throw new SiddhiAppRuntimeException("Duration '" + durationName + "' used for incrementalAggregator:aggregateBaseTime() is invalid.");
            }
        }
        return IncrementalTimeConverterUtil.getStartTimeOfAggregates(time, duration, this.timeZone);
    }

    protected Object execute(Object data, State state) {
        return null;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.OBJECT;
    }
}

