/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.input.MultiProcessStreamReceiver;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.selector.QuerySelector;

public class StateMultiProcessStreamReceiver
extends MultiProcessStreamReceiver {
    private QuerySelector querySelector;

    public StateMultiProcessStreamReceiver(String streamId, int processCount, Object patternSyncObject, SiddhiQueryContext siddhiQueryContext) {
        super(streamId, processCount, patternSyncObject, siddhiQueryContext);
    }

    @Override
    public void setNext(Processor next) {
        super.setNext(next);
        this.querySelector = (QuerySelector)((StreamPreStateProcessor)next).getThisStatePostProcessor().getNextProcessor();
    }

    @Override
    protected void processAndClear(int processIndex, StreamEvent streamEvent) {
        ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>();
        ComplexEventChunk<StreamEvent> currentStreamEventChunk = new ComplexEventChunk<StreamEvent>(streamEvent, streamEvent);
        ComplexEventChunk<StateEvent> eventChunk = ((StreamPreStateProcessor)this.nextProcessors[processIndex]).processAndReturn(currentStreamEventChunk);
        if (eventChunk.getFirst() != null) {
            retEventChunk.add(eventChunk.getFirst());
        }
        eventChunk.clear();
        if (this.querySelector != null) {
            while (retEventChunk.hasNext()) {
                StateEvent stateEvent = (StateEvent)retEventChunk.next();
                retEventChunk.remove();
                this.querySelector.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent));
            }
        }
    }
}

