/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WindowedPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter<RateLimiterState> {
    private final Long value;
    private Comparator comparator;
    private Scheduler scheduler;

    public WindowedPerSnapshotOutputRateLimiter(Long value, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        super(wrappedSnapshotOutputRateLimiter, siddhiQueryContext, groupBy);
        this.value = value;
        this.comparator = (event1, event2) -> {
            if (Arrays.equals(event1.getOutputData(), event2.getOutputData())) {
                return 0;
            }
            return 1;
        };
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext);
        this.scheduler.setStreamEventFactory(new StreamEventFactory(0, 0, 0));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        LinkedList<ComplexEventChunk> outputEventChunks = new LinkedList<ComplexEventChunk>();
        complexEventChunk.reset();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                block5: while (complexEventChunk.hasNext()) {
                    Object event = complexEventChunk.next();
                    if (event instanceof GroupedComplexEvent) {
                        event = ((GroupedComplexEvent)event).getComplexEvent();
                    }
                    if (event.getType() == ComplexEvent.Type.TIMER) {
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                        continue;
                    }
                    if (event.getType() == ComplexEvent.Type.CURRENT) {
                        complexEventChunk.remove();
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                        state.eventList.add(event);
                        continue;
                    }
                    if (event.getType() == ComplexEvent.Type.EXPIRED) {
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                        Iterator iterator = state.eventList.iterator();
                        while (iterator.hasNext()) {
                            ComplexEvent currentEvent = (ComplexEvent)iterator.next();
                            if (this.comparator.compare(currentEvent, event) != 0) continue;
                            iterator.remove();
                            continue block5;
                        }
                        continue;
                    }
                    if (event.getType() != ComplexEvent.Type.RESET) continue;
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)event, state);
                    state.eventList.clear();
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        this.sendToCallBacks(outputEventChunks);
    }

    private void tryFlushEvents(List<ComplexEventChunk> outputEventChunks, ComplexEvent event, RateLimiterState state) {
        if (event.getTimestamp() >= state.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>();
            for (ComplexEvent complexEvent : state.eventList) {
                outputEventChunk.add(this.cloneComplexEvent(complexEvent));
            }
            outputEventChunks.add(outputEventChunk);
            state.scheduledTime = state.scheduledTime + this.value;
            this.scheduler.notifyAt(state.scheduledTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionCreated() {
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                long currentTime = System.currentTimeMillis();
                state.scheduledTime = currentTime + this.value;
                this.scheduler.notifyAt(state.scheduledTime);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class RateLimiterState
    extends State {
        private List<ComplexEvent> eventList = new LinkedList<ComplexEvent>();
        private long scheduledTime;

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.eventList.isEmpty() && this.scheduledTime == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("EventList", this.eventList);
            state.put("ScheduledTime", this.scheduledTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.eventList = (List)state.get("EventList");
            this.scheduledTime = (Long)state.get("ScheduledTime");
        }
    }
}

