/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import io.siddhi.core.event.stream.holder.StreamEventClonerHolder;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.BatchingWindowProcessor;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

@Extension(name="cron", namespace="", description="This window outputs the arriving events as and when they arrive, and resets (expires) the window periodically based on the given cron expression.", parameters={@Parameter(name="cron.expression", description="The cron expression that resets the window.", type={DataType.STRING})}, parameterOverloads={@ParameterOverload(parameterNames={"cron.expression"})}, examples={@Example(syntax="define stream InputEventStream (symbol string, price float, volume int);\n\n@info(name = 'query1')\nfrom InputEventStream#cron('*/5 * * * * ?')\nselect symbol, sum(price) as totalPrice \ninsert into OutputStream;", description="This let the totalPrice to gradually increase and resets to zero as a batch every 5 seconds."), @Example(syntax="define stream StockEventStream (symbol string, price float, volume int)\ndefine window StockEventWindow (symbol string, price float, volume int) cron('*/5 * * * * ?');\n\n@info(name = 'query0')\nfrom StockEventStream\ninsert into StockEventWindow;\n\n@info(name = 'query1')\nfrom StockEventWindow \nselect symbol, sum(price) as totalPrice\ninsert into OutputStream ;", description="The defined window will let the totalPrice to gradually increase and resets to zero as a batch every 5 seconds.")})
public class CronWindowProcessor
extends BatchingWindowProcessor<WindowState>
implements Job {
    private static final Logger log = LogManager.getLogger(CronWindowProcessor.class);
    private final String jobGroup = "CronWindowGroup";
    private Scheduler scheduler;
    private String jobName;
    private String cronString;
    private StreamEventClonerHolder streamEventClonerHolder;
    private String id;

    @Override
    protected StateFactory<WindowState> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, StreamEventClonerHolder streamEventClonerHolder, boolean outputExpectsExpiredEvents, boolean findToBeExecuted, SiddhiQueryContext siddhiQueryContext) {
        this.streamEventClonerHolder = streamEventClonerHolder;
        this.id = siddhiQueryContext.getName() + "_" + siddhiQueryContext.generateNewId();
        if (attributeExpressionExecutors != null) {
            this.cronString = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
        }
        return () -> new WindowState(streamEventClonerHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        WindowState windowState = state;
        synchronized (windowState) {
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                state.currentEventQueue.add(clonedStreamEvent);
                streamEventChunk.remove();
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.scheduler == null) {
            this.scheduleCronJob(this.cronString);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.deleteJob(new JobKey(this.jobName, "CronWindowGroup"));
            }
        }
        catch (SchedulerException e) {
            log.error(ExceptionUtil.getMessageWithContext(e, this.siddhiQueryContext.getSiddhiAppContext()) + " Error while removing the cron job '" + "CronWindowGroup" + ":'" + this.jobName + "'.", (Throwable)e);
        }
    }

    private void scheduleCronJob(String cronString) {
        try {
            StdSchedulerFactory schedFact = new StdSchedulerFactory();
            this.scheduler = schedFact.getScheduler();
            this.jobName = this.siddhiQueryContext.getName() + "_EventRemoverJob_" + this.siddhiQueryContext.generateNewId();
            JobKey jobKey = new JobKey(this.jobName, "CronWindowGroup");
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
            this.scheduler.start();
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("windowProcessor", (Object)this);
            JobDetail job = JobBuilder.newJob(CronWindowProcessor.class).withIdentity(this.jobName, "CronWindowGroup").usingJobData(dataMap).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("EventRemoverTrigger_" + this.id, "CronWindowGroup").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            log.error("Error while instantiating quartz scheduler", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvents() {
        Map allStates = this.stateHolder.getAllStates();
        try {
            for (Map.Entry allStatesEntry : allStates.entrySet()) {
                for (Map.Entry stateEntry : allStatesEntry.getValue().entrySet()) {
                    WindowState windowState = (WindowState)stateEntry.getValue();
                    ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>();
                    WindowState windowState2 = windowState;
                    synchronized (windowState2) {
                        if (windowState.currentEventQueue.getFirst() != null) {
                            long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
                            while (windowState.expiredEventQueue.hasNext()) {
                                StreamEvent expiredEvent = windowState.expiredEventQueue.next();
                                expiredEvent.setTimestamp(currentTime);
                            }
                            if (windowState.expiredEventQueue.getFirst() != null) {
                                streamEventChunk.add(windowState.expiredEventQueue.getFirst());
                            }
                            windowState.expiredEventQueue.clear();
                            while (windowState.currentEventQueue.hasNext()) {
                                StreamEvent currentEvent = windowState.currentEventQueue.next();
                                StreamEvent toExpireEvent = this.streamEventClonerHolder.getStreamEventCloner().copyStreamEvent(currentEvent);
                                toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                                windowState.expiredEventQueue.add(toExpireEvent);
                            }
                            streamEventChunk.add(windowState.currentEventQueue.getFirst());
                            windowState.currentEventQueue.clear();
                        }
                    }
                    SiddhiAppContext.startPartitionFlow(allStatesEntry.getKey());
                    SiddhiAppContext.startGroupByFlow(stateEntry.getKey());
                    try {
                        if (streamEventChunk.getFirst() == null) continue;
                        this.nextProcessor.process(streamEventChunk);
                    }
                    finally {
                        SiddhiAppContext.stopGroupByFlow();
                        SiddhiAppContext.stopPartitionFlow();
                    }
                }
            }
        }
        finally {
            this.stateHolder.returnAllStates(allStates);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        if (log.isDebugEnabled()) {
            log.debug("Running Event Remover Job");
        }
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        CronWindowProcessor windowProcessor = (CronWindowProcessor)dataMap.get((Object)"windowProcessor");
        windowProcessor.dispatchEvents();
    }

    class WindowState
    extends State {
        private SnapshotableStreamEventQueue currentEventQueue;
        private SnapshotableStreamEventQueue expiredEventQueue;

        WindowState(StreamEventClonerHolder streamEventClonerHolder) {
            this.currentEventQueue = new SnapshotableStreamEventQueue(streamEventClonerHolder);
            this.expiredEventQueue = new SnapshotableStreamEventQueue(streamEventClonerHolder);
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("CurrentEventQueue", this.currentEventQueue.getSnapshot());
            state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.currentEventQueue.restore((SnapshotStateList)state.get("CurrentEventQueue"));
            this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
        }

        @Override
        public boolean canDestroy() {
            return this.expiredEventQueue.getFirst() == null && this.currentEventQueue.getFirst() == null;
        }
    }
}

