/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.trigger;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.stream.StreamJunction;
import io.siddhi.core.trigger.AbstractTrigger;
import io.siddhi.core.util.ExceptionUtil;
import io.siddhi.core.util.parser.helper.QueryParserHelper;
import io.siddhi.core.util.statistics.ThroughputTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import io.siddhi.query.api.definition.TriggerDefinition;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class CronTrigger
extends AbstractTrigger
implements Job {
    private static final Logger log = LogManager.getLogger(CronTrigger.class);
    private TriggerDefinition triggerDefinition;
    private SiddhiAppContext siddhiAppContext;
    private StreamJunction streamJunction;
    private Scheduler scheduler;
    private String jobName;
    private String jobGroup = "TriggerGroup";
    private ThroughputTracker throughputTracker;

    @Override
    public void init(TriggerDefinition triggerDefinition, SiddhiAppContext siddhiAppContext, StreamJunction streamJunction) {
        this.triggerDefinition = triggerDefinition;
        this.siddhiAppContext = siddhiAppContext;
        this.streamJunction = streamJunction;
        if (siddhiAppContext.getStatisticsManager() != null) {
            this.throughputTracker = QueryParserHelper.createThroughputTracker(siddhiAppContext, triggerDefinition.getId(), "Trigger", null);
        }
    }

    @Override
    public TriggerDefinition getTriggerDefinition() {
        return this.triggerDefinition;
    }

    @Override
    public String getId() {
        return this.triggerDefinition.getId();
    }

    @Override
    public void start() {
        this.scheduleCronJob(this.triggerDefinition.getAt(), this.triggerDefinition.getId());
    }

    @Override
    public void stop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.deleteJob(new JobKey(this.jobName, this.jobGroup));
                if (log.isDebugEnabled()) {
                    log.debug("Scheduler job: " + this.jobName + " Group: " + this.jobGroup + " has successfully stopped");
                }
            }
        }
        catch (SchedulerException e) {
            log.error(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while removing the cron trigger job '" + this.jobGroup + "':'" + this.jobName + "'", (Throwable)e);
        }
    }

    private void scheduleCronJob(String cronString, String elementId) {
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            this.scheduler = schedulerFactory.getScheduler();
            this.jobName = "TriggerJob_" + elementId;
            JobKey jobKey = new JobKey(this.jobName, this.jobGroup);
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
            this.scheduler.start();
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("trigger", (Object)this);
            JobDetail job = JobBuilder.newJob(CronTrigger.class).withIdentity(this.jobName, this.jobGroup).usingJobData(dataMap).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity("TriggerJob_" + elementId, this.jobGroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronString)).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            log.error(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Error while instantiating quartz scheduler for trigger '" + this.triggerDefinition.getId() + "'.", (Throwable)e);
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        CronTrigger cronEventTrigger = (CronTrigger)dataMap.get((Object)"trigger");
        if (log.isDebugEnabled()) {
            log.debug("Running Trigger Job '" + cronEventTrigger.getId() + "'");
        }
        cronEventTrigger.sendEvent();
    }

    private void sendEvent() {
        long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
        if (this.throughputTracker != null && Level.BASIC.compareTo(this.siddhiAppContext.getRootMetricsLevel()) <= 0) {
            this.throughputTracker.eventIn();
        }
        Event event = new Event(currentTime, new Object[]{currentTime});
        try {
            this.streamJunction.sendEvent(event);
        }
        catch (Exception e) {
            this.streamJunction.handleError(event, e);
        }
    }

    @Override
    public boolean isStateful() {
        return false;
    }
}

