/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.query.api.definition.Attribute;

public class AttributeConverter {
    public static Object getPropertyValue(Object propertyValue, Attribute.Type attributeType) {
        switch (attributeType) {
            case BOOL: {
                if (propertyValue instanceof Boolean) {
                    return propertyValue;
                }
                if (propertyValue instanceof String) {
                    return Boolean.parseBoolean((String)propertyValue);
                }
                throw new SiddhiAppRuntimeException("No supported mapping for '" + propertyValue + "' with class '" + propertyValue.getClass().getName() + "' to attribute type '" + attributeType + "'.");
            }
            case DOUBLE: {
                if (propertyValue instanceof Double) {
                    return propertyValue;
                }
                if (propertyValue instanceof Float) {
                    return (double)((Float)propertyValue).floatValue();
                }
                if (propertyValue instanceof String) {
                    return Double.parseDouble((String)propertyValue);
                }
                throw new SiddhiAppRuntimeException("No supported mapping for '" + propertyValue + "' with class '" + propertyValue.getClass().getName() + "' to attribute type '" + attributeType + "'.");
            }
            case FLOAT: {
                if (propertyValue instanceof Float) {
                    return propertyValue;
                }
                if (propertyValue instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)propertyValue));
                }
                throw new SiddhiAppRuntimeException("No supported mapping for '" + propertyValue + "' with class '" + propertyValue.getClass().getName() + "' to attribute type '" + attributeType + "'.");
            }
            case INT: {
                if (propertyValue instanceof Integer) {
                    return propertyValue;
                }
                if (propertyValue instanceof String) {
                    return Integer.parseInt((String)propertyValue);
                }
                throw new SiddhiAppRuntimeException("No supported mapping for '" + propertyValue + "' with class '" + propertyValue.getClass().getName() + "' to attribute type '" + attributeType + "'.");
            }
            case LONG: {
                if (propertyValue instanceof Integer) {
                    return (long)((Integer)propertyValue).intValue();
                }
                if (propertyValue instanceof Long) {
                    return propertyValue;
                }
                if (propertyValue instanceof String) {
                    return Long.parseLong((String)propertyValue);
                }
                throw new SiddhiAppRuntimeException("No supported mapping for '" + propertyValue + "' with class '" + propertyValue.getClass().getName() + "' to attribute type '" + attributeType + "'.");
            }
            case STRING: {
                return propertyValue.toString();
            }
            case OBJECT: {
                return propertyValue;
            }
        }
        throw new SiddhiAppRuntimeException("Attribute type: " + attributeType + " not supported by XML mapping.");
    }

    public Object getPropertyValue(String propertyValue, Attribute.Type attributeType) {
        switch (attributeType) {
            case BOOL: {
                return Boolean.parseBoolean(propertyValue);
            }
            case DOUBLE: {
                return Double.parseDouble(propertyValue);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(propertyValue));
            }
            case INT: {
                return Integer.parseInt(propertyValue);
            }
            case LONG: {
                return Long.parseLong(propertyValue);
            }
            case STRING: {
                return propertyValue;
            }
            case OBJECT: {
                return propertyValue;
            }
        }
        throw new SiddhiAppRuntimeException("No supported mapping for '" + propertyValue + "' with class '" + propertyValue.getClass().getName() + "' to attribute type '" + attributeType + "'.");
    }
}

