/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.executor;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.table.CacheTable;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.Collection;
import java.util.List;

public class AndMultiPrimaryKeyCollectionExecutor
implements CollectionExecutor {
    private final String compositePrimaryKey;
    private final List<ExpressionExecutor> multiPrimaryKeyExpressionExecutors;
    private CacheTable cacheTable;

    public AndMultiPrimaryKeyCollectionExecutor(String compositePrimaryKey, List<ExpressionExecutor> multiPrimaryKeyExpressionExecutors, CacheTable cacheTable) {
        this.compositePrimaryKey = compositePrimaryKey;
        this.multiPrimaryKeyExpressionExecutors = multiPrimaryKeyExpressionExecutors;
        this.cacheTable = cacheTable;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>();
        Collection<StreamEvent> storeEventSet = this.findEvents(matchingEvent, indexedEventHolder);
        if (storeEventSet == null) {
            return (StreamEvent)returnEventChunk.getFirst();
        }
        for (StreamEvent storeEvent : storeEventSet) {
            if (this.cacheTable != null) {
                this.cacheTable.updateCachePolicyAttribute(storeEvent);
            }
            if (storeEventCloner != null) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                continue;
            }
            returnEventChunk.add(storeEvent);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    public List<ExpressionExecutor> getMultiPrimaryKeyExpressionExecutors() {
        return this.multiPrimaryKeyExpressionExecutors;
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return indexedEventHolder.findEvents(this.compositePrimaryKey, Compare.Operator.EQUAL, this.constructPrimaryKeyValue(matchingEvent, this.multiPrimaryKeyExpressionExecutors));
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return indexedEventHolder.containsEventSet(this.compositePrimaryKey, Compare.Operator.EQUAL, this.constructPrimaryKeyValue(matchingEvent, this.multiPrimaryKeyExpressionExecutors));
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        indexedEventHolder.delete(this.compositePrimaryKey, Compare.Operator.EQUAL, this.constructPrimaryKeyValue(deletingEvent, this.multiPrimaryKeyExpressionExecutors));
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        return CollectionExecutor.Cost.SINGLE_RETURN_INDEX_MATCHING;
    }

    private Object constructPrimaryKeyValue(StateEvent matchingEvent, List<ExpressionExecutor> multiPrimaryKeyExpressionExecutors) {
        if (multiPrimaryKeyExpressionExecutors.size() == 1) {
            return multiPrimaryKeyExpressionExecutors.get(0).execute(matchingEvent);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ExpressionExecutor expressionExecutor : multiPrimaryKeyExpressionExecutors) {
            stringBuilder.append(expressionExecutor.execute(matchingEvent)).append(":-:");
        }
        return stringBuilder.toString();
    }

    public String getCompositePrimaryKey() {
        return this.compositePrimaryKey;
    }
}

