/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.error.handler.store;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import io.siddhi.core.util.error.handler.exception.ErrorStoreException;
import io.siddhi.core.util.error.handler.model.ErroneousEvent;
import io.siddhi.core.util.error.handler.model.ErrorEntry;
import io.siddhi.core.util.error.handler.model.PublishableErrorEntry;
import io.siddhi.core.util.error.handler.util.ErroneousEventType;
import io.siddhi.core.util.error.handler.util.ErrorHandlerUtils;
import io.siddhi.core.util.error.handler.util.ErrorOccurrence;
import io.siddhi.core.util.error.handler.util.ErrorType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ErrorStore {
    private static final Logger log = LogManager.getLogger(ErrorStore.class);
    private int bufferSize = 1024;
    private boolean dropWhenBufferFull = true;
    private Disruptor<PublishableErrorEntry> disruptor;
    private RingBuffer<PublishableErrorEntry> ringBuffer;

    public ErrorStore() {
        DaemonThreadFactory threadFactory = DaemonThreadFactory.INSTANCE;
        this.disruptor = new Disruptor(PublishableErrorEntry.EVENT_FACTORY, this.bufferSize, (ThreadFactory)threadFactory, ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWith(this.getEventHandler());
        this.ringBuffer = this.disruptor.start();
    }

    protected void produce(long timestamp, String siddhiAppName, String streamName, byte[] eventAsBytes, String cause, byte[] stackTraceAsBytes, byte[] originalPayloadAsBytes, String errorOccurrence, String eventType, String errorType) {
        try {
            long seq = this.dropWhenBufferFull ? this.ringBuffer.tryNext() : this.ringBuffer.next();
            PublishableErrorEntry publishableErrorEntry = (PublishableErrorEntry)this.ringBuffer.get(seq);
            publishableErrorEntry.setTimestamp(timestamp);
            publishableErrorEntry.setSiddhiAppName(siddhiAppName);
            publishableErrorEntry.setStreamName(streamName);
            publishableErrorEntry.setEventAsBytes(eventAsBytes);
            publishableErrorEntry.setCause(cause);
            publishableErrorEntry.setStackTraceAsBytes(stackTraceAsBytes);
            publishableErrorEntry.setOriginalPayloadAsBytes(originalPayloadAsBytes);
            publishableErrorEntry.setErrorOccurrence(errorOccurrence);
            publishableErrorEntry.setEventType(eventType);
            publishableErrorEntry.setErrorType(errorType);
            this.ringBuffer.publish(seq);
        }
        catch (InsufficientCapacityException e) {
            log.error("Insufficient capacity in the buffer.", (Throwable)e);
        }
    }

    protected EventHandler<PublishableErrorEntry>[] getEventHandler() {
        EventHandler eventHandler = (event, sequence, endOfBatch) -> this.saveEntry(event.getTimestamp(), event.getSiddhiAppName(), event.getStreamName(), event.getEventAsBytes(), event.getCause(), event.getStackTraceAsBytes(), event.getOriginalPayloadAsBytes(), event.getErrorOccurrence(), event.getEventType(), event.getErrorType());
        return new EventHandler[]{eventHandler};
    }

    public abstract void setProperties(Map var1);

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setDropWhenBufferFull(boolean dropWhenBufferFull) {
        this.dropWhenBufferFull = dropWhenBufferFull;
    }

    public void saveMappingError(String siddhiAppName, List<ErroneousEvent> erroneousEvents, String streamName) {
        for (ErroneousEvent erroneousEvent : erroneousEvents) {
            try {
                this.save(siddhiAppName, streamName, erroneousEvent, ErroneousEventType.PAYLOAD_STRING, ErrorOccurrence.BEFORE_SOURCE_MAPPING, ErrorType.MAPPING);
            }
            catch (ErrorStoreException e) {
                log.error("Failed to save erroneous event.", (Throwable)e);
            }
        }
    }

    public void saveTransportError(String siddhiAppName, ErroneousEvent erroneousEvent, ErroneousEventType eventType, String streamName, ErrorOccurrence errorOccurrence) {
        try {
            this.save(siddhiAppName, streamName, erroneousEvent, eventType, errorOccurrence, ErrorType.TRANSPORT);
        }
        catch (ErrorStoreException e) {
            log.error("Failed to save erroneous event.", (Throwable)e);
        }
    }

    protected void save(String siddhiAppName, String streamName, ErroneousEvent erroneousEvent, ErroneousEventType eventType, ErrorOccurrence errorOccurrence, ErrorType errorType) throws ErrorStoreException {
        long timestamp = System.currentTimeMillis();
        Object event = erroneousEvent.getEvent();
        Throwable throwable = erroneousEvent.getThrowable();
        String cause = throwable != null ? (throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage()) : "Unknown";
        try {
            Object originalPayload = erroneousEvent.getOriginalPayload();
            byte[] eventAsBytes = event != null && eventType == ErroneousEventType.PAYLOAD_STRING ? ErrorHandlerUtils.getAsBytes(event.toString()) : ErrorHandlerUtils.getAsBytes(event);
            byte[] stackTraceAsBytes = throwable != null ? ErrorHandlerUtils.getThrowableStackTraceAsBytes(throwable) : ErrorHandlerUtils.getAsBytes(null);
            byte[] originalPayloadAsBytes = ErrorHandlerUtils.getAsBytes(originalPayload);
            this.produce(timestamp, siddhiAppName, streamName, eventAsBytes, cause, stackTraceAsBytes, originalPayloadAsBytes, errorOccurrence.toString(), eventType.toString(), errorType.toString());
        }
        catch (IOException e) {
            throw new ErrorStoreException("Failure occurred during byte array conversion.", e);
        }
    }

    protected abstract void saveEntry(long var1, String var3, String var4, byte[] var5, String var6, byte[] var7, byte[] var8, String var9, String var10, String var11) throws ErrorStoreException;

    public abstract List<ErrorEntry> loadErrorEntries(String var1, Map<String, String> var2);

    public abstract ErrorEntry loadErrorEntry(int var1);

    protected ErrorEntry constructErrorEntry(int id, long timestamp, String siddhiAppName, String streamName, byte[] eventAsBytes, String cause, byte[] stackTraceAsBytes, byte[] originalPayloadAsBytes, ErrorOccurrence errorOccurrence, ErroneousEventType erroneousEventType, ErrorType errorType) throws IOException, ClassNotFoundException {
        String stackTrace = stackTraceAsBytes != null ? (String)ErrorHandlerUtils.getAsObject(stackTraceAsBytes) : null;
        String originalPayloadString = originalPayloadAsBytes != null ? ErrorHandlerUtils.getOriginalPayloadString(ErrorHandlerUtils.getAsObject(originalPayloadAsBytes)) : null;
        return new ErrorEntry(id, timestamp, siddhiAppName, streamName, eventAsBytes, cause, stackTrace, originalPayloadString, errorOccurrence, erroneousEventType, errorType);
    }

    public abstract void discardErrorEntry(int var1);

    public abstract void discardErrorEntries(String var1);

    public abstract int getTotalErrorEntriesCount();

    public abstract int getErrorEntriesCount(String var1);

    public abstract void purge(Map var1);
}

