/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.transport;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.NoSuchAttributeException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateBuilder {
    private static final Pattern DYNAMIC_PATTERN = Pattern.compile("(\\{\\{[^{}]*\\}\\})|[{}]");
    private static final String SPLIT_PATTERN = "(\\{\\.\\{|\\}\\.\\})";
    private int[] positionArray;
    private String[] splitTemplateArray;
    private boolean isObjectMessage = false;
    private int objectIndex = -1;
    private Attribute.Type type = Attribute.Type.STRING;

    public TemplateBuilder(StreamDefinition streamDefinition, String template) {
        this.parse(streamDefinition, template);
    }

    public static Map<String, Object> convert(Event event, Map<String, TemplateBuilder> converterMap) {
        HashMap<String, Object> mapped = new HashMap<String, Object>();
        for (Map.Entry<String, TemplateBuilder> entry : converterMap.entrySet()) {
            mapped.put(entry.getKey(), entry.getValue().build(event));
        }
        return mapped;
    }

    public static Object[] convert(Event event, TemplateBuilder[] templateBuilders) {
        Object[] mapped = new String[templateBuilders.length];
        int i = 0;
        for (TemplateBuilder templateBuilder : templateBuilders) {
            mapped[i] = templateBuilder.build(event);
            ++i;
        }
        return mapped;
    }

    public Object build(Event event) {
        if (this.isObjectMessage) {
            return event.getData()[this.objectIndex];
        }
        return this.formatMessage(event.getData());
    }

    public Object build(ComplexEvent complexEvent) {
        if (this.isObjectMessage) {
            return complexEvent.getOutputData()[this.objectIndex];
        }
        return this.formatMessage(complexEvent.getOutputData());
    }

    private void parse(StreamDefinition streamDefinition, String template) {
        if (Arrays.asList(streamDefinition.getAttributeNameArray()).contains(template.trim())) {
            this.objectIndex = streamDefinition.getAttributePosition(template.trim());
            this.isObjectMessage = true;
            this.type = ((Attribute)streamDefinition.getAttributeList().get(this.objectIndex)).getType();
        } else {
            if (template.matches("^`[^\\s]*`$")) {
                template = template.replaceAll("^`|`$", "");
            }
            String templateString = this.parseTextMessage(streamDefinition, template);
            String[] templateArray = templateString.split(SPLIT_PATTERN);
            this.assignTemplateArrayAttributePositions(templateArray, streamDefinition);
            this.splitTemplateArray = templateArray;
        }
    }

    private String parseTextMessage(StreamDefinition streamDefinition, String template) {
        List<String> attributes = Arrays.asList(streamDefinition.getAttributeNameArray());
        StringBuffer result = new StringBuffer();
        Matcher m = DYNAMIC_PATTERN.matcher(template);
        while (m.find()) {
            if (m.group(1) != null) {
                int attrIndex = attributes.indexOf(m.group(1).replaceAll("\\p{Ps}", "").replaceAll("\\p{Pe}", ""));
                if (attrIndex >= 0) {
                    m.appendReplacement(result, String.format("{.{%s}.}", attrIndex));
                    continue;
                }
                throw new NoSuchAttributeException(String.format("Attribute : %s does not exist in %s.", m.group(1), streamDefinition));
            }
            m.appendReplacement(result, m.group() + "");
        }
        m.appendTail(result);
        return result.toString();
    }

    private String formatMessage(Object[] outputData) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.splitTemplateArray.length; ++i) {
            if (i % 2 == 0) {
                stringBuilder.append(this.splitTemplateArray[i]);
                continue;
            }
            stringBuilder.append(outputData[this.positionArray[i / 2]]);
        }
        return stringBuilder.toString();
    }

    private void assignTemplateArrayAttributePositions(String[] splitTemplateArray, StreamDefinition streamDefinition) {
        this.positionArray = new int[splitTemplateArray.length / 2];
        int positionCount = 0;
        for (int i = 0; i < splitTemplateArray.length; ++i) {
            if (i % 2 == 0) continue;
            try {
                this.positionArray[positionCount++] = Integer.parseInt(splitTemplateArray[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new SiddhiAppCreationException(String.format("Invalid mapping configuration provided in %s. Mapping parameter should be surrounded only with '{{' and '}}'.", streamDefinition));
            }
        }
    }

    public Attribute.Type getType() {
        return this.type;
    }

    public boolean isObjectMessage() {
        return this.isObjectMessage;
    }
}

