/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event;

import io.siddhi.core.event.ComplexEvent;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ComplexEventChunk<E extends ComplexEvent>
implements Iterator<E>,
Serializable {
    private static final Logger log = Logger.getLogger(ComplexEventChunk.class);
    private static final long serialVersionUID = 3185987841726255019L;
    protected E first;
    protected E previousToLastReturned;
    protected E lastReturned;
    protected E last;
    protected boolean isBatch = false;

    public ComplexEventChunk(boolean isBatch) {
        this.isBatch = isBatch;
    }

    @Deprecated
    public ComplexEventChunk() {
        this.isBatch = true;
    }

    @Deprecated
    public ComplexEventChunk(E first, E last) {
        this.first = first;
        this.last = last;
        this.isBatch = true;
    }

    public ComplexEventChunk(E first, E last, boolean isBatch) {
        this.first = first;
        this.last = last;
        this.isBatch = isBatch;
    }

    public void insertBeforeCurrent(E events) {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        E currentEvent = this.getLastEvent(events);
        if (this.previousToLastReturned != null) {
            this.previousToLastReturned.setNext((ComplexEvent)events);
        } else {
            this.first = events;
        }
        this.previousToLastReturned = currentEvent;
        currentEvent.setNext((ComplexEvent)this.lastReturned);
    }

    public void insertAfterCurrent(E streamEvents) {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        E currentEvent = this.getLastEvent(streamEvents);
        ComplexEvent nextEvent = this.lastReturned.getNext();
        this.lastReturned.setNext((ComplexEvent)streamEvents);
        currentEvent.setNext(nextEvent);
    }

    public void add(E complexEvents) {
        if (this.first == null) {
            this.first = complexEvents;
        } else {
            this.last.setNext((ComplexEvent)complexEvents);
        }
        this.last = this.getLastEvent(complexEvents);
    }

    private E getLastEvent(E complexEvents) {
        Object lastEvent;
        for (lastEvent = complexEvents; lastEvent != null && lastEvent.getNext() != null && lastEvent.getNext() != complexEvents; lastEvent = lastEvent.getNext()) {
        }
        if (lastEvent != null && lastEvent.getNext() == complexEvents) {
            lastEvent.setNext(null);
            if (Level.WARN.isGreaterOrEqual((Priority)log.getEffectiveLevel())) {
                RuntimeException exception = new RuntimeException("Unexpected event loop found!");
                log.warn((Object)(exception.getMessage() + " If the usecase is legitimate, increase the log level to ERROR for class: " + this.getClass().getName()), (Throwable)exception);
            }
        }
        return lastEvent;
    }

    @Override
    public boolean hasNext() {
        if (this.lastReturned != null) {
            return this.lastReturned.getNext() != null;
        }
        if (this.previousToLastReturned != null) {
            return this.previousToLastReturned.getNext() != null;
        }
        return this.first != null;
    }

    @Override
    public E next() {
        ComplexEvent returnEvent;
        if (this.lastReturned != null) {
            returnEvent = this.lastReturned.getNext();
            this.previousToLastReturned = this.lastReturned;
        } else {
            returnEvent = this.previousToLastReturned != null ? this.previousToLastReturned.getNext() : this.first;
        }
        if (returnEvent == null) {
            throw new NoSuchElementException();
        }
        this.lastReturned = returnEvent;
        return (E)returnEvent;
    }

    @Override
    public void remove() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.previousToLastReturned != null) {
            this.previousToLastReturned.setNext(this.lastReturned.getNext());
        } else {
            this.first = this.lastReturned.getNext();
            if (this.first == null) {
                this.last = null;
            }
        }
        this.lastReturned.setNext(null);
        this.lastReturned = null;
    }

    public void detach() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        if (this.previousToLastReturned != null) {
            this.previousToLastReturned.setNext(null);
        } else {
            this.clear();
        }
        this.lastReturned = null;
    }

    public E detachAllBeforeCurrent() {
        if (this.lastReturned == null) {
            throw new IllegalStateException();
        }
        E firstEvent = null;
        if (this.previousToLastReturned != null) {
            this.previousToLastReturned.setNext(null);
            firstEvent = this.first;
            this.first = this.lastReturned;
            this.previousToLastReturned = null;
        }
        return firstEvent;
    }

    public void clear() {
        this.previousToLastReturned = null;
        this.lastReturned = null;
        this.first = null;
        this.last = null;
    }

    public void reset() {
        this.previousToLastReturned = null;
        this.lastReturned = null;
    }

    public E getFirst() {
        return this.first;
    }

    public E getLast() {
        return this.last;
    }

    public E poll() {
        if (this.first != null) {
            E firstEvent = this.first;
            this.first = this.first.getNext();
            firstEvent.setNext(null);
            return firstEvent;
        }
        return null;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public void setBatch(boolean batch) {
        this.isBatch = batch;
    }

    public String toString() {
        return "EventChunk{first=" + this.first + '}';
    }
}

