/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query;

import io.siddhi.core.aggregation.AggregationRuntime;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.OnDemandQueryRuntimeException;
import io.siddhi.core.query.OnDemandQueryRuntime;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.OnDemandQueryRuntimeUtil;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.window.Window;
import java.util.ArrayList;

public class FindOnDemandQueryRuntime
extends OnDemandQueryRuntime {
    private CompiledCondition compiledCondition;
    private SiddhiQueryContext siddhiQueryContext;
    private Table table;
    private Window window;
    private MetaStreamEvent.EventType eventType;
    private AggregationRuntime aggregation;

    public FindOnDemandQueryRuntime(Table table, CompiledCondition compiledCondition, String queryName, MetaStreamEvent metaStreamEvent) {
        this.table = table;
        this.compiledCondition = compiledCondition;
        this.queryName = queryName;
        this.eventType = metaStreamEvent.getEventType();
        this.metaStreamEvent = metaStreamEvent;
        this.setOutputAttributes(metaStreamEvent.getLastInputDefinition().getAttributeList());
    }

    public FindOnDemandQueryRuntime(Window window, CompiledCondition compiledCondition, String queryName, MetaStreamEvent metaStreamEvent) {
        this.window = window;
        this.compiledCondition = compiledCondition;
        this.queryName = queryName;
        this.eventType = metaStreamEvent.getEventType();
        this.metaStreamEvent = metaStreamEvent;
        this.setOutputAttributes(metaStreamEvent.getLastInputDefinition().getAttributeList());
    }

    public FindOnDemandQueryRuntime(AggregationRuntime aggregation, CompiledCondition compiledCondition, String queryName, MetaStreamEvent metaStreamEvent, SiddhiQueryContext siddhiQueryContext) {
        this.aggregation = aggregation;
        this.compiledCondition = compiledCondition;
        this.siddhiQueryContext = siddhiQueryContext;
        this.queryName = queryName;
        this.eventType = metaStreamEvent.getEventType();
        this.metaStreamEvent = metaStreamEvent;
        this.setOutputAttributes(metaStreamEvent.getLastInputDefinition().getAttributeList());
    }

    @Override
    public Event[] execute() {
        try {
            StateEvent stateEvent = new StateEvent(1, 0);
            StreamEvent streamEvents = null;
            switch (this.eventType) {
                case TABLE: {
                    streamEvents = this.table.find(stateEvent, this.compiledCondition);
                    break;
                }
                case WINDOW: {
                    streamEvents = this.window.find(stateEvent, this.compiledCondition);
                    break;
                }
                case AGGREGATE: {
                    stateEvent = new StateEvent(2, 0);
                    streamEvents = this.aggregation.find(stateEvent, this.compiledCondition, this.siddhiQueryContext);
                    break;
                }
            }
            if (streamEvents == null) {
                return null;
            }
            if (this.selector != null) {
                if (this.eventType == MetaStreamEvent.EventType.AGGREGATE) {
                    return OnDemandQueryRuntimeUtil.executeSelector(this.stateEventFactory, null, streamEvents, 1, this.selector);
                }
                return OnDemandQueryRuntimeUtil.executeSelector(this.stateEventFactory, null, streamEvents, 0, this.selector);
            }
            ArrayList<Event> events = new ArrayList<Event>();
            while (streamEvents != null) {
                events.add(new Event(streamEvents.getTimestamp(), streamEvents.getOutputData()));
                streamEvents = streamEvents.getNext();
            }
            return events.toArray(new Event[0]);
        }
        catch (Throwable t) {
            throw new OnDemandQueryRuntimeException("Error executing '" + this.queryName + "', " + t.getMessage(), t);
        }
    }

    @Override
    public void reset() {
        if (this.selector != null) {
            this.selector.process(this.generateResetComplexEventChunk(this.metaStreamEvent));
        }
    }

    @Override
    public OnDemandQueryRuntime.TYPE getType() {
        return OnDemandQueryRuntime.TYPE.FIND;
    }

    private ComplexEventChunk<ComplexEvent> generateResetComplexEventChunk(MetaStreamEvent metaStreamEvent) {
        StreamEvent streamEvent = new StreamEvent(metaStreamEvent.getBeforeWindowData().size(), metaStreamEvent.getOnAfterWindowData().size(), metaStreamEvent.getOutputData().size());
        streamEvent.setType(ComplexEvent.Type.RESET);
        StateEvent stateEvent = this.stateEventFactory.newInstance();
        if (this.eventType == MetaStreamEvent.EventType.AGGREGATE) {
            stateEvent.addEvent(1, streamEvent);
        } else {
            stateEvent.addEvent(0, streamEvent);
        }
        stateEvent.setType(ComplexEvent.Type.RESET);
        ComplexEventChunk<ComplexEvent> complexEventChunk = new ComplexEventChunk<ComplexEvent>(true);
        complexEventChunk.add(stateEvent);
        return complexEventChunk;
    }
}

