/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.exception.OnDemandQueryRuntimeException;
import io.siddhi.core.query.OnDemandQueryRuntime;
import io.siddhi.core.query.processor.stream.window.QueryableProcessor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.CompiledSelection;
import io.siddhi.query.api.definition.Attribute;
import java.util.ArrayList;
import java.util.List;

public class SelectOnDemandQueryRuntime
extends OnDemandQueryRuntime {
    private final CompiledSelection compiledSelection;
    private final CompiledCondition compiledCondition;
    private QueryableProcessor queryableProcessor;

    public SelectOnDemandQueryRuntime(QueryableProcessor queryableProcessor, CompiledCondition compiledCondition, CompiledSelection compiledSelection, List<Attribute> expectedOutputAttributeList, String queryName) {
        this.queryableProcessor = queryableProcessor;
        this.compiledCondition = compiledCondition;
        this.compiledSelection = compiledSelection;
        this.queryName = queryName;
        this.outputAttributes = expectedOutputAttributeList.toArray(new Attribute[expectedOutputAttributeList.size()]);
    }

    @Override
    public Event[] execute() {
        try {
            StreamEvent streamEvents;
            StateEvent stateEvent = new StateEvent(1, 0);
            if (streamEvents == null) {
                return null;
            }
            ArrayList<Event> events = new ArrayList<Event>();
            for (streamEvents = this.queryableProcessor.query(stateEvent, this.compiledCondition, this.compiledSelection, this.outputAttributes); streamEvents != null; streamEvents = streamEvents.getNext()) {
                events.add(new Event(streamEvents.getTimestamp(), streamEvents.getOutputData()));
            }
            return events.toArray(new Event[0]);
        }
        catch (Throwable t) {
            throw new OnDemandQueryRuntimeException("Error executing '" + this.queryName + "', " + t.getMessage(), t);
        }
    }

    @Override
    public void reset() {
        if (this.selector != null) {
            this.selector.process(this.generateResetComplexEventChunk(this.metaStreamEvent));
        }
    }

    private ComplexEventChunk<ComplexEvent> generateResetComplexEventChunk(MetaStreamEvent metaStreamEvent) {
        StreamEvent streamEvent = new StreamEvent(metaStreamEvent.getOutputData().size(), metaStreamEvent.getOnAfterWindowData().size(), metaStreamEvent.getOutputData().size());
        streamEvent.setType(ComplexEvent.Type.RESET);
        StateEvent stateEvent = this.stateEventFactory.newInstance();
        if (this.eventType == MetaStreamEvent.EventType.AGGREGATE) {
            stateEvent.addEvent(1, streamEvent);
        } else {
            stateEvent.addEvent(0, streamEvent);
        }
        stateEvent.setType(ComplexEvent.Type.RESET);
        ComplexEventChunk<ComplexEvent> complexEventChunk = new ComplexEventChunk<ComplexEvent>(true);
        complexEventChunk.add(stateEvent);
        return complexEventChunk;
    }

    @Override
    public OnDemandQueryRuntime.TYPE getType() {
        return OnDemandQueryRuntime.TYPE.SELECT;
    }
}

