/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.input.stream.state.AbsentPreStateProcessor;
import io.siddhi.core.query.input.stream.state.LogicalPreStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.core.util.Scheduler;
import io.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import io.siddhi.query.api.expression.constant.TimeConstant;
import java.util.Iterator;
import java.util.Map;

public class AbsentLogicalPreStateProcessor
extends LogicalPreStateProcessor
implements AbsentPreStateProcessor {
    private Scheduler scheduler;
    private long waitingTime = -1L;

    public AbsentLogicalPreStateProcessor(LogicalStateElement.Type type, StateInputStream.Type stateType, TimeConstant waitingTime) {
        super(type, stateType);
        if (waitingTime != null) {
            this.waitingTime = waitingTime.value();
        }
    }

    @Override
    public void init(SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), false, () -> new LogicalStreamPreState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastArrivalTime(long timestamp) {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            ((LogicalStreamPreState)state).lastArrivalTime = timestamp;
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    @Override
    protected void addState(StateEvent stateEvent, StreamPreStateProcessor.StreamPreState state) {
        if (!((LogicalStreamPreState)state).active) {
            return;
        }
        this.lock.lock();
        try {
            super.addState(stateEvent, state);
            if (!this.isStartState && this.waitingTime != -1L) {
                this.scheduler.notifyAt(stateEvent.getTimestamp() + this.waitingTime);
                if (this.partnerStatePreProcessor instanceof AbsentLogicalPreStateProcessor) {
                    ((AbsentLogicalPreStateProcessor)this.partnerStatePreProcessor).scheduler.notifyAt(stateEvent.getTimestamp() + ((AbsentLogicalPreStateProcessor)this.partnerStatePreProcessor).waitingTime);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEveryState(StateEvent stateEvent) {
        StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
        clonedEvent.setType(ComplexEvent.Type.CURRENT);
        if (clonedEvent.getStreamEvent(this.stateId) != null) {
            clonedEvent.setTimestamp(clonedEvent.getStreamEvent(this.stateId).getTimestamp());
        }
        clonedEvent.setEvent(this.stateId, null);
        clonedEvent.setEvent(this.partnerStatePreProcessor.stateId, null);
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            state.getNewAndEveryStateEventList().add(clonedEvent);
            this.partnerStatePreProcessor.addEventToNewAndEveryStateEventList(clonedEvent);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            if (!((LogicalStreamPreState)state).active) {
                return;
            }
            boolean notProcessed = true;
            ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>(false);
            this.lock.lock();
            try {
                long currentTime = complexEventChunk.getFirst().getTimestamp();
                if (currentTime >= ((LogicalStreamPreState)state).lastArrivalTime + this.waitingTime) {
                    StateEvent stateEvent;
                    if (this.isStartState && this.stateType == StateInputStream.Type.SEQUENCE && state.getNewAndEveryStateEventList().isEmpty() && state.getPendingStateEventList().isEmpty()) {
                        StateEvent stateEvent2 = this.stateEventFactory.newInstance();
                        this.addState(stateEvent2);
                    } else if (this.stateType == StateInputStream.Type.SEQUENCE && !state.getNewAndEveryStateEventList().isEmpty()) {
                        this.resetState();
                    }
                    this.updateState();
                    StateEvent expiredStateEvent = null;
                    Iterator iterator = state.getPendingStateEventList().iterator();
                    while (iterator.hasNext()) {
                        stateEvent = (StateEvent)iterator.next();
                        if (this.isExpired(stateEvent, currentTime)) {
                            expiredStateEvent = stateEvent;
                            iterator.remove();
                            continue;
                        }
                        if (!this.waitingTimePassed(currentTime, stateEvent)) continue;
                        iterator.remove();
                        if (this.logicalType == LogicalStateElement.Type.OR && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) == null) {
                            stateEvent.addEvent(this.stateId, this.streamEventFactory.newInstance());
                            retEventChunk.add(stateEvent);
                            continue;
                        }
                        if (this.logicalType == LogicalStateElement.Type.AND && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) {
                            retEventChunk.add(stateEvent);
                            continue;
                        }
                        if (this.logicalType != LogicalStateElement.Type.AND || stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) continue;
                        stateEvent.addEvent(this.stateId, this.streamEventFactory.newInstance());
                    }
                    if (expiredStateEvent != null && this.withinEveryPreStateProcessor != null) {
                        this.withinEveryPreStateProcessor.addEveryState(expiredStateEvent);
                        this.withinEveryPreStateProcessor.updateState();
                    }
                    retEventChunk.reset();
                    boolean bl = notProcessed = retEventChunk.getFirst() == null;
                    while (retEventChunk.hasNext()) {
                        stateEvent = (StateEvent)retEventChunk.next();
                        retEventChunk.remove();
                        stateEvent.setTimestamp(currentTime);
                        this.sendEvent(stateEvent, state);
                    }
                    ((LogicalStreamPreState)state).lastArrivalTime = 0L;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.thisStatePostProcessor.nextEveryStatePreProcessor != null || notProcessed && this.isStartState) {
                long nextBreak = ((LogicalStreamPreState)state).lastArrivalTime == 0L ? this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime() + this.waitingTime : ((LogicalStreamPreState)state).lastArrivalTime + this.waitingTime;
                this.scheduler.notifyAt(nextBreak);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    private boolean waitingTimePassed(long currentTime, StateEvent event) {
        if (event.getStreamEvent(this.stateId) == null) {
            return currentTime >= event.getTimestamp() + this.waitingTime;
        }
        return currentTime >= event.getStreamEvent(this.stateId).getTimestamp() + this.waitingTime;
    }

    private void sendEvent(StateEvent stateEvent, StreamPreStateProcessor.StreamPreState state) {
        if (this.thisStatePostProcessor.nextProcessor != null) {
            this.thisStatePostProcessor.nextProcessor.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, false));
        }
        if (this.thisStatePostProcessor.nextStatePreProcessor != null) {
            this.thisStatePostProcessor.nextStatePreProcessor.addState(stateEvent);
        }
        if (this.thisStatePostProcessor.nextEveryStatePreProcessor != null) {
            this.thisStatePostProcessor.nextEveryStatePreProcessor.addEveryState(stateEvent);
        } else if (this.isStartState) {
            ((LogicalStreamPreState)state).active = false;
            if (this.logicalType == LogicalStateElement.Type.OR && this.partnerStatePreProcessor instanceof AbsentLogicalPreStateProcessor) {
                ((AbsentLogicalPreStateProcessor)this.partnerStatePreProcessor).setActive(false);
            }
        }
        if (this.thisStatePostProcessor.callbackPreStateProcessor != null) {
            this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
        }
    }

    private void setActive(boolean active) {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            ((LogicalStreamPreState)state).active = active;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            if (!((LogicalStreamPreState)state).active) {
                ComplexEventChunk<StateEvent> complexEventChunk2 = returnEventChunk;
                return complexEventChunk2;
            }
            complexEventChunk.reset();
            StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
            this.lock.lock();
            try {
                Iterator iterator = state.getPendingStateEventList().iterator();
                while (iterator.hasNext()) {
                    StateEvent stateEvent = (StateEvent)iterator.next();
                    if (this.logicalType == LogicalStateElement.Type.OR && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) {
                        iterator.remove();
                        continue;
                    }
                    StreamEvent currentStreamEvent = stateEvent.getStreamEvent(this.stateId);
                    stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                    this.process(stateEvent);
                    if (this.waitingTime != -1L || this.stateType == StateInputStream.Type.SEQUENCE && this.logicalType == LogicalStateElement.Type.AND && this.thisStatePostProcessor.nextEveryStatePreProcessor != null) {
                        stateEvent.setEvent(this.stateId, currentStreamEvent);
                    }
                    if (this.thisLastProcessor.isEventReturned()) {
                        this.thisLastProcessor.clearProcessedEvent();
                        iterator.remove();
                        if (this.stateType == StateInputStream.Type.SEQUENCE) {
                            this.partnerStatePreProcessor.getPendingStateEventList().remove(stateEvent);
                        }
                    }
                    if (state.isStateChanged()) continue;
                    switch (this.stateType) {
                        case PATTERN: {
                            stateEvent.setEvent(this.stateId, currentStreamEvent);
                            break;
                        }
                        case SEQUENCE: {
                            stateEvent.setEvent(this.stateId, currentStreamEvent);
                            iterator.remove();
                        }
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
            ComplexEventChunk<StateEvent> complexEventChunk3 = returnEventChunk;
            return complexEventChunk3;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void partitionCreated() {
        block6: {
            StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
            try {
                if (state.isStarted()) break block6;
                state.started();
                if (!this.isStartState || this.waitingTime == -1L || !((LogicalStreamPreState)state).active) break block6;
                this.lock.lock();
                try {
                    this.scheduler.notifyAt(this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime() + this.waitingTime);
                }
                finally {
                    this.lock.unlock();
                }
            }
            finally {
                this.stateHolder.returnState(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean partnerCanProceed(StateEvent stateEvent) {
        StreamPreStateProcessor.StreamPreState state = (StreamPreStateProcessor.StreamPreState)this.stateHolder.getState();
        try {
            boolean process;
            if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && ((LogicalStreamPreState)state).lastArrivalTime > 0L) {
                process = false;
            } else if (this.waitingTime == -1L) {
                if (this.thisStatePostProcessor.nextEveryStatePreProcessor == null) {
                    process = stateEvent.getStreamEvent(this.stateId) == null;
                } else if (((LogicalStreamPreState)state).lastArrivalTime > 0L) {
                    process = false;
                    ((LogicalStreamPreState)state).lastArrivalTime = 0L;
                    this.init();
                } else {
                    process = true;
                }
            } else {
                process = stateEvent.getStreamEvent(this.stateId) != null;
            }
            boolean bl = process;
            return bl;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class LogicalStreamPreState
    extends StreamPreStateProcessor.StreamPreState {
        private volatile long lastArrivalTime;
        private boolean active;

        LogicalStreamPreState() {
            super(AbsentLogicalPreStateProcessor.this);
            this.active = true;
        }

        @Override
        public boolean canDestroy() {
            return super.canDestroy() && this.lastArrivalTime == 0L;
        }

        @Override
        public Map<String, Object> snapshot() {
            Map<String, Object> snapshot = super.snapshot();
            snapshot.put("IsActive", this.active);
            snapshot.put("LastArrivalTime", this.lastArrivalTime);
            return snapshot;
        }

        @Override
        public void restore(Map<String, Object> state) {
            super.restore(state);
            this.active = (Boolean)state.get("IsActive");
            this.lastArrivalTime = (Long)state.get("LastArrivalTime");
        }
    }
}

