/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventCloner;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.input.stream.state.AbsentPreStateProcessor;
import io.siddhi.core.query.input.stream.state.PreStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPostStateProcessor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class StreamPreStateProcessor
implements PreStateProcessor {
    protected int stateId;
    protected boolean isStartState;
    protected StateInputStream.Type stateType;
    protected long withinTime = -1L;
    protected int[] startStateIds;
    protected PreStateProcessor withinEveryPreStateProcessor;
    protected StreamPostStateProcessor thisStatePostProcessor;
    protected StreamPostStateProcessor thisLastProcessor;
    protected Processor nextProcessor;
    protected ReentrantLock lock = new ReentrantLock();
    protected StateEventFactory stateEventFactory;
    protected StreamEventCloner streamEventCloner;
    protected StateEventCloner stateEventCloner;
    protected StreamEventFactory streamEventFactory;
    protected SiddhiQueryContext siddhiQueryContext;
    protected StateHolder<StreamPreState> stateHolder;
    protected Comparator eventTimeComparator = new Comparator<StateEvent>(){

        @Override
        public int compare(StateEvent o1, StateEvent o2) {
            if (o1.getTimestamp() == -1L) {
                if (o2.getTimestamp() == -1L) {
                    return 0;
                }
                return 1;
            }
            if (o2.getTimestamp() == -1L) {
                return -1;
            }
            return Long.compare(o1.getTimestamp(), o2.getTimestamp());
        }
    };

    public StreamPreStateProcessor(StateInputStream.Type stateType) {
        this.stateType = stateType;
    }

    public void init(SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), false, () -> new StreamPreState());
    }

    @Override
    public StreamPostStateProcessor getThisStatePostProcessor() {
        return this.thisStatePostProcessor;
    }

    public void setThisStatePostProcessor(StreamPostStateProcessor thisStatePostProcessor) {
        this.thisStatePostProcessor = thisStatePostProcessor;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        throw new IllegalStateException("process method of StreamPreStateProcessor should not be called. processAndReturn method is used for handling event chunks.");
    }

    protected boolean isExpired(StateEvent pendingStateEvent, long currentTimestamp) {
        if (this.withinTime != -1L) {
            for (int startStateId : this.startStateIds) {
                StreamEvent streamEvent = pendingStateEvent.getStreamEvent(startStateId);
                if (streamEvent == null || Math.abs(pendingStateEvent.getStreamEvent(startStateId).getTimestamp() - currentTimestamp) <= this.withinTime) continue;
                return true;
            }
        }
        return false;
    }

    protected void process(StateEvent stateEvent) {
        StreamPreState state = this.stateHolder.getState();
        try {
            state.currentStateEventChunk.add(stateEvent);
            state.currentStateEventChunk.reset();
            state.stateChanged = false;
            this.nextProcessor.process(state.currentStateEventChunk);
            state.currentStateEventChunk.reset();
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public Processor getNextProcessor() {
        return this.nextProcessor;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        this.nextProcessor = processor;
    }

    @Override
    public void setToLast(Processor processor) {
        if (this.nextProcessor == null) {
            this.nextProcessor = processor;
        } else {
            this.nextProcessor.setToLast(processor);
        }
    }

    @Override
    public void init() {
        StreamPreState state = this.stateHolder.getState();
        try {
            if (this.isStartState && (!state.initialized || this.thisStatePostProcessor.nextEveryStatePreProcessor != null || this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextStatePreProcessor instanceof AbsentPreStateProcessor)) {
                StateEvent stateEvent = this.stateEventFactory.newInstance();
                this.addState(stateEvent);
                state.initialized = true;
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    public StreamPostStateProcessor getThisLastProcessor() {
        return this.thisLastProcessor;
    }

    public void setThisLastProcessor(StreamPostStateProcessor thisLastProcessor) {
        this.thisLastProcessor = thisLastProcessor;
    }

    @Override
    public void addState(StateEvent stateEvent) {
        StreamPreState state = this.stateHolder.getState();
        try {
            this.addState(stateEvent, state);
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    protected void addState(StateEvent stateEvent, StreamPreState state) {
        this.lock.lock();
        try {
            if (this.stateType == StateInputStream.Type.SEQUENCE) {
                if (state.newAndEveryStateEventList.isEmpty()) {
                    state.newAndEveryStateEventList.add(stateEvent);
                }
            } else {
                state.newAndEveryStateEventList.add(stateEvent);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEveryState(StateEvent stateEvent) {
        this.lock.lock();
        try {
            StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
            clonedEvent.setType(ComplexEvent.Type.CURRENT);
            for (int i = this.stateId; i < clonedEvent.getStreamEvents().length; ++i) {
                clonedEvent.setEvent(i, null);
            }
            StreamPreState state = this.stateHolder.getState();
            try {
                state.newAndEveryStateEventList.add(clonedEvent);
            }
            finally {
                this.stateHolder.returnState(state);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setWithinEveryPreStateProcessor(PreStateProcessor withinEveryPreStateProcessor) {
        this.withinEveryPreStateProcessor = withinEveryPreStateProcessor;
    }

    public void stateChanged() {
        StreamPreState state = this.stateHolder.getState();
        try {
            state.stateChanged = true;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public boolean isStartState() {
        return this.isStartState;
    }

    @Override
    public void setStartState(boolean isStartState) {
        this.isStartState = isStartState;
    }

    public void setStateEventFactory(StateEventFactory stateEventFactory) {
        this.stateEventFactory = stateEventFactory;
    }

    public void setStreamEventFactory(StreamEventFactory streamEventFactory) {
        this.streamEventFactory = streamEventFactory;
    }

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventCloner = streamEventCloner;
    }

    public void setStateEventCloner(StateEventCloner stateEventCloner) {
        this.stateEventCloner = stateEventCloner;
    }

    @Override
    public void resetState() {
        StreamPreState state = this.stateHolder.getState();
        this.lock.lock();
        try {
            state.pendingStateEventList.clear();
            if (this.isStartState && state.newAndEveryStateEventList.isEmpty()) {
                if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && !((StreamPreStateProcessor)this.thisStatePostProcessor.nextStatePreProcessor).getPendingStateEventList().isEmpty()) {
                    return;
                }
                this.init();
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public void updateState() {
        this.lock.lock();
        try {
            StreamPreState state = this.stateHolder.getState();
            try {
                state.newAndEveryStateEventList.sort(this.eventTimeComparator);
                state.pendingStateEventList.addAll(state.newAndEveryStateEventList);
                state.newAndEveryStateEventList.clear();
            }
            finally {
                this.stateHolder.returnState(state);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireEvents(long timestamp) {
        StreamPreState state = this.stateHolder.getState();
        this.lock.lock();
        try {
            StateEvent stateEvent;
            StateEvent expiredStateEvent = null;
            Iterator iterator = state.pendingStateEventList.iterator();
            while (iterator.hasNext() && this.isExpired(stateEvent = (StateEvent)iterator.next(), timestamp)) {
                iterator.remove();
                if (stateEvent.getType() == ComplexEvent.Type.EXPIRED) continue;
                stateEvent.setType(ComplexEvent.Type.EXPIRED);
                expiredStateEvent = stateEvent;
            }
            iterator = state.newAndEveryStateEventList.iterator();
            while (iterator.hasNext()) {
                stateEvent = (StateEvent)iterator.next();
                if (!this.isExpired(stateEvent, timestamp)) continue;
                iterator.remove();
                if (stateEvent.getType() == ComplexEvent.Type.EXPIRED) continue;
                stateEvent.setType(ComplexEvent.Type.EXPIRED);
                expiredStateEvent = stateEvent;
            }
            if (expiredStateEvent != null && this.withinEveryPreStateProcessor != null) {
                this.withinEveryPreStateProcessor.addEveryState(expiredStateEvent);
                this.withinEveryPreStateProcessor.updateState();
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        StreamPreState state = this.stateHolder.getState();
        this.lock.lock();
        try {
            Iterator iterator = state.pendingStateEventList.iterator();
            while (iterator.hasNext()) {
                StateEvent stateEvent = (StateEvent)iterator.next();
                stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                this.process(stateEvent);
                if (this.thisLastProcessor.isEventReturned()) {
                    this.thisLastProcessor.clearProcessedEvent();
                    returnEventChunk.add(stateEvent);
                }
                if (state.stateChanged) {
                    iterator.remove();
                    continue;
                }
                switch (this.stateType) {
                    case PATTERN: {
                        stateEvent.setEvent(this.stateId, null);
                        break;
                    }
                    case SEQUENCE: {
                        stateEvent.setEvent(this.stateId, null);
                        if (this.removeOnNoStateChange(this.stateType)) {
                            iterator.remove();
                        }
                        if (this.thisStatePostProcessor.callbackPreStateProcessor == null) break;
                        this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
        return returnEventChunk;
    }

    protected boolean removeOnNoStateChange(StateInputStream.Type stateType) {
        return stateType == StateInputStream.Type.SEQUENCE;
    }

    @Override
    public int getStateId() {
        return this.stateId;
    }

    @Override
    public void setStateId(int stateId) {
        this.stateId = stateId;
    }

    @Override
    public void setWithinTime(long withinTime) {
        this.withinTime = withinTime;
    }

    @Override
    public void setStartStateIds(int[] stateIds) {
        this.startStateIds = stateIds;
    }

    public List<StateEvent> getPendingStateEventList() {
        StreamPreState state = this.stateHolder.getState();
        try {
            LinkedList linkedList = state.pendingStateEventList;
            return linkedList;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class StreamPreState
    extends State {
        private ComplexEventChunk<StateEvent> currentStateEventChunk = new ComplexEventChunk(false);
        private LinkedList<StateEvent> pendingStateEventList = new LinkedList();
        private LinkedList<StateEvent> newAndEveryStateEventList = new LinkedList();
        private volatile boolean stateChanged = false;
        private boolean initialized;
        private boolean started;

        StreamPreState() {
        }

        @Override
        public boolean canDestroy() {
            return this.currentStateEventChunk.getFirst() == null && this.pendingStateEventList.isEmpty() && this.newAndEveryStateEventList.isEmpty() && !this.initialized;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("FirstEvent", this.currentStateEventChunk.getFirst());
            state.put("PendingStateEventList", this.pendingStateEventList);
            state.put("NewAndEveryStateEventList", this.newAndEveryStateEventList);
            state.put("Initialized", this.initialized);
            state.put("Started", this.started);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.currentStateEventChunk.clear();
            this.currentStateEventChunk.add((StateEvent)state.get("FirstEvent"));
            this.pendingStateEventList = (LinkedList)state.get("PendingStateEventList");
            this.newAndEveryStateEventList = (LinkedList)state.get("NewAndEveryStateEventList");
            this.initialized = (Boolean)state.get("Initialized");
            this.started = (Boolean)state.get("Started");
        }

        public ComplexEventChunk<StateEvent> getCurrentStateEventChunk() {
            return this.currentStateEventChunk;
        }

        public LinkedList<StateEvent> getPendingStateEventList() {
            return this.pendingStateEventList;
        }

        public LinkedList<StateEvent> getNewAndEveryStateEventList() {
            return this.newAndEveryStateEventList;
        }

        public boolean isStateChanged() {
            return this.stateChanged;
        }

        public void setStateChanged(boolean stateChanged) {
            this.stateChanged = stateChanged;
        }

        public void started() {
            this.started = true;
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

