/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.Scheduler;
import io.siddhi.core.util.parser.SchedulerParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter<RateLimiterState> {
    private final Long value;
    private Scheduler scheduler;

    public PerSnapshotOutputRateLimiter(Long value, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        super(wrappedSnapshotOutputRateLimiter, siddhiQueryContext, groupBy);
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiQueryContext);
        this.scheduler.setStreamEventFactory(new StreamEventFactory(0, 0, 0));
        this.scheduler.init(this.lockWrapper, this.siddhiQueryContext.getName());
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        complexEventChunk.reset();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                while (complexEventChunk.hasNext()) {
                    Object object = complexEventChunk.next();
                    if (object.getType() == ComplexEvent.Type.TIMER) {
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)object, state);
                        continue;
                    }
                    if (object.getType() == ComplexEvent.Type.CURRENT) {
                        complexEventChunk.remove();
                        this.tryFlushEvents(outputEventChunks, (ComplexEvent)object, state);
                        state.lastEvent = (ComplexEvent)object;
                        continue;
                    }
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object, state);
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event, RateLimiterState state) {
        if (event.getTimestamp() >= state.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            if (state.lastEvent != null) {
                outputEventChunk.add(this.cloneComplexEvent(state.lastEvent));
            }
            outputEventChunks.add(outputEventChunk);
            state.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(state.scheduledTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void partitionCreated() {
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                long currentTime = System.currentTimeMillis();
                state.scheduledTime = currentTime + this.value;
                this.scheduler.notifyAt(state.scheduledTime);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class RateLimiterState
    extends State {
        public long scheduledTime;
        private ComplexEventChunk<ComplexEvent> eventChunk = new ComplexEventChunk(false);
        private ComplexEvent lastEvent;

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.eventChunk.getFirst() == null && this.scheduledTime == 0L && this.lastEvent == null;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("EventChunk", this.eventChunk.getFirst());
            state.put("ScheduledTime", this.scheduledTime);
            state.put("LastEvent", this.lastEvent);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.eventChunk.clear();
            this.eventChunk.add((ComplexEvent)state.get("EventList"));
            this.scheduledTime = (Long)state.get("ScheduledTime");
            this.lastEvent = (ComplexEvent)state.get("LastEvent");
        }
    }
}

