/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventCloner;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import org.apache.log4j.Logger;

public abstract class SnapshotOutputRateLimiter<S extends State>
implements Schedulable {
    private static final Logger log = Logger.getLogger(SnapshotOutputRateLimiter.class);
    protected final StateHolder<S> stateHolder;
    protected StreamEventCloner streamEventCloner;
    protected StateEventCloner stateEventCloner;
    protected SiddhiQueryContext siddhiQueryContext;
    protected LockWrapper lockWrapper;
    private WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter;
    private boolean receiveStreamEvent;

    protected SnapshotOutputRateLimiter(WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, SiddhiQueryContext siddhiQueryContext, boolean groupBy) {
        this.wrappedSnapshotOutputRateLimiter = wrappedSnapshotOutputRateLimiter;
        this.siddhiQueryContext = siddhiQueryContext;
        this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), groupBy, this.init());
    }

    protected abstract StateFactory<S> init();

    @Override
    public abstract void process(ComplexEventChunk var1);

    public void setStreamEventCloner(StreamEventCloner streamEventCloner) {
        this.streamEventCloner = streamEventCloner;
        this.receiveStreamEvent = true;
    }

    public void setStateEventCloner(StateEventCloner stateEventCloner) {
        this.stateEventCloner = stateEventCloner;
        this.receiveStreamEvent = false;
    }

    protected void sendToCallBacks(ComplexEventChunk complexEventChunk) {
        this.wrappedSnapshotOutputRateLimiter.passToCallBacks(complexEventChunk);
    }

    protected ComplexEvent cloneComplexEvent(ComplexEvent complexEvent) {
        if (this.receiveStreamEvent) {
            return this.streamEventCloner.copyStreamEvent((StreamEvent)complexEvent);
        }
        return this.stateEventCloner.copyStateEvent((StateEvent)complexEvent);
    }

    public abstract void partitionCreated();

    public void setQueryLock(LockWrapper lockWrapper) {
        this.lockWrapper = lockWrapper;
    }
}

