/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.time;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.GroupedComplexEvent;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.util.Schedulable;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FirstGroupByPerTimeOutputRateLimiter
extends OutputRateLimiter<RateLimiterState>
implements Schedulable {
    private static final Logger log = Logger.getLogger(FirstGroupByPerTimeOutputRateLimiter.class);
    private final Long value;
    private String id;

    public FirstGroupByPerTimeOutputRateLimiter(String id, Long value) {
        this.id = id;
        this.value = value;
    }

    @Override
    protected StateFactory<RateLimiterState> init() {
        return () -> new RateLimiterState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<GroupedComplexEvent> outputEventChunk = new ComplexEventChunk<GroupedComplexEvent>(complexEventChunk.isBatch());
        complexEventChunk.reset();
        RateLimiterState state = (RateLimiterState)this.stateHolder.getState();
        try {
            RateLimiterState rateLimiterState = state;
            synchronized (rateLimiterState) {
                long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
                while (complexEventChunk.hasNext()) {
                    Object event = complexEventChunk.next();
                    complexEventChunk.remove();
                    GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)event;
                    Long outputTime = (Long)state.groupByOutputTime.get(groupedComplexEvent.getGroupKey());
                    if (outputTime != null && outputTime + this.value > currentTime) continue;
                    state.groupByOutputTime.put(groupedComplexEvent.getGroupKey(), currentTime);
                    outputEventChunk.add(groupedComplexEvent);
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
        if (outputEventChunk.getFirst() != null) {
            this.sendToCallBacks(outputEventChunk);
        }
    }

    @Override
    public void partitionCreated() {
    }

    class RateLimiterState
    extends State {
        private Map<String, Long> groupByOutputTime = new HashMap<String, Long>();

        RateLimiterState() {
        }

        @Override
        public boolean canDestroy() {
            return this.groupByOutputTime.isEmpty();
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("GroupByOutputTime", this.groupByOutputTime);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.groupByOutputTime = (Map)state.get("GroupByOutputTime");
        }
    }
}

