/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.processor.stream.window;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.Processor;
import io.siddhi.core.query.processor.stream.window.SlidingFindableWindowProcessor;
import io.siddhi.core.table.Table;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.expression.Expression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Extension(name="frequent", namespace="", description="This window returns the latest events with the most frequently occurred value for a given attribute(s). Frequency calculation for this window processor is based on Misra-Gries counting algorithm.", deprecated=true, parameters={@Parameter(name="event.count", description="The number of most frequent events to be emitted to the stream.", type={DataType.INT}), @Parameter(name="attribute", description="The attributes to group the events. If no attributes are given, the concatenation of all the attributes of the event is considered.", type={DataType.STRING}, optional=true, dynamic=true, defaultValue="The concatenation of all the attributes of the event is considered.")}, parameterOverloads={@ParameterOverload(parameterNames={"event.count"}), @ParameterOverload(parameterNames={"event.count", "attribute"})}, examples={@Example(syntax="@info(name = 'query1')\nfrom purchase[price >= 30]#window.frequent(2)\nselect cardNo, price\ninsert all events into PotentialFraud;", description="This will returns the 2 most frequent events."), @Example(syntax="@info(name = 'query1')\nfrom purchase[price >= 30]#window.frequent(2, cardNo)\nselect cardNo, price\ninsert all events into PotentialFraud;", description="This will returns the 2 latest events with the most frequently appeared card numbers.")})
@Deprecated
public class FrequentWindowProcessor
extends SlidingFindableWindowProcessor<WindowState> {
    private VariableExpressionExecutor[] variableExpressionExecutors;
    private int mostFrequentCount;

    @Override
    protected StateFactory<WindowState> init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        this.mostFrequentCount = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()));
        this.variableExpressionExecutors = new VariableExpressionExecutor[attributeExpressionExecutors.length - 1];
        for (int i = 1; i < attributeExpressionExecutors.length; ++i) {
            this.variableExpressionExecutors[i - 1] = (VariableExpressionExecutor)attributeExpressionExecutors[i];
        }
        return () -> new WindowState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, WindowState state) {
        FrequentWindowProcessor frequentWindowProcessor = this;
        synchronized (frequentWindowProcessor) {
            StreamEvent streamEvent = streamEventChunk.getFirst();
            streamEventChunk.clear();
            long currentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            while (streamEvent != null) {
                StreamEvent next = streamEvent.getNext();
                streamEvent.setNext(null);
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                String key = this.generateKey(streamEvent);
                StreamEvent oldEvent = state.map.put(key, clonedEvent);
                if (oldEvent != null) {
                    state.countMap.put(key, (Integer)state.countMap.get(key) + 1);
                    streamEventChunk.add(streamEvent);
                } else if (state.map.size() > this.mostFrequentCount) {
                    ArrayList keys = new ArrayList(state.countMap.keySet());
                    for (int i = 0; i < this.mostFrequentCount; ++i) {
                        int count = (Integer)state.countMap.get(keys.get(i)) - 1;
                        if (count == 0) {
                            state.countMap.remove(keys.get(i));
                            StreamEvent expiredEvent = (StreamEvent)state.map.remove(keys.get(i));
                            expiredEvent.setTimestamp(currentTime);
                            streamEventChunk.add(expiredEvent);
                            continue;
                        }
                        state.countMap.put(keys.get(i), count);
                    }
                    if (state.map.size() > this.mostFrequentCount) {
                        state.map.remove(key);
                    } else {
                        state.countMap.put(key, 1);
                        streamEventChunk.add(streamEvent);
                    }
                } else {
                    state.countMap.put(this.generateKey(streamEvent), 1);
                    streamEventChunk.add(streamEvent);
                }
                streamEvent = next;
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    private String generateKey(StreamEvent event) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.variableExpressionExecutors.length == 0) {
            for (Object data : event.getOutputData()) {
                stringBuilder.append(data);
            }
        } else {
            for (VariableExpressionExecutor executor : this.variableExpressionExecutors) {
                stringBuilder.append(event.getAttribute(executor.getPosition()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, WindowState state, SiddhiQueryContext siddhiQueryContext) {
        return OperatorParser.constructOperator(state.map.values(), condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition, StreamEventCloner streamEventCloner, WindowState state) {
        return ((Operator)compiledCondition).find(matchingEvent, state.map.values(), streamEventCloner);
    }

    class WindowState
    extends State {
        private ConcurrentHashMap<String, Integer> countMap = new ConcurrentHashMap();
        private ConcurrentHashMap<String, StreamEvent> map = new ConcurrentHashMap();

        WindowState() {
        }

        @Override
        public boolean canDestroy() {
            return this.countMap.isEmpty() && this.map.isEmpty();
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("CountMap", this.countMap);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.countMap = (ConcurrentHashMap)state.get("CountMap");
        }
    }
}

