/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table.holder;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.table.CacheTable;
import io.siddhi.core.table.holder.IndexEventHolder;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.table.holder.PrimaryKeyReferenceHolder;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.expression.condition.Compare;
import java.util.Map;
import java.util.TreeMap;

public class IndexEventHolderForCache
extends IndexEventHolder
implements IndexedEventHolder {
    private CacheTable cacheTable;

    public IndexEventHolderForCache(StreamEventFactory tableStreamEventFactory, StreamEventConverter eventConverter, PrimaryKeyReferenceHolder[] primaryKeyReferenceHolders, boolean isPrimaryNumeric, Map<String, Integer> indexMetaData, AbstractDefinition tableDefinition, SiddhiAppContext siddhiAppContext) {
        super(tableStreamEventFactory, eventConverter, primaryKeyReferenceHolders, isPrimaryNumeric, indexMetaData, tableDefinition, siddhiAppContext);
    }

    @Override
    protected void handleCachePolicyAttributeUpdate(StreamEvent streamEvent) {
        this.cacheTable.updateCachePolicyAttribute(streamEvent);
    }

    public void setCacheTable(CacheTable cacheTable) {
        this.cacheTable = cacheTable;
    }

    @Override
    public boolean containsEventSet(String attribute, Compare.Operator operator, Object value) {
        if (this.primaryKeyData != null && attribute.equals(this.primaryKeyAttributes)) {
            switch (operator) {
                case LESS_THAN: {
                    StreamEvent foundEvent = (StreamEvent)((TreeMap)this.primaryKeyData).lowerKey(value);
                    if (foundEvent != null) {
                        this.handleCachePolicyAttributeUpdate(foundEvent);
                        return true;
                    }
                    return false;
                }
                case GREATER_THAN: {
                    StreamEvent foundEvent = (StreamEvent)((TreeMap)this.primaryKeyData).higherKey(value);
                    if (foundEvent != null) {
                        this.handleCachePolicyAttributeUpdate(foundEvent);
                        return true;
                    }
                    return false;
                }
                case LESS_THAN_EQUAL: {
                    StreamEvent foundEvent = (StreamEvent)((TreeMap)this.primaryKeyData).ceilingKey(value);
                    if (foundEvent != null) {
                        this.handleCachePolicyAttributeUpdate(foundEvent);
                        return true;
                    }
                    return false;
                }
                case GREATER_THAN_EQUAL: {
                    StreamEvent foundEvent = (StreamEvent)((TreeMap)this.primaryKeyData).floorKey(value);
                    if (foundEvent != null) {
                        this.handleCachePolicyAttributeUpdate(foundEvent);
                        return true;
                    }
                    return false;
                }
                case EQUAL: {
                    StreamEvent foundEvent = (StreamEvent)this.primaryKeyData.get(value);
                    if (foundEvent != null) {
                        this.handleCachePolicyAttributeUpdate(foundEvent);
                        return true;
                    }
                    return false;
                }
                case NOT_EQUAL: {
                    return this.primaryKeyData.size() > 1;
                }
            }
        } else {
            TreeMap currentIndexedData = (TreeMap)this.indexData.get(attribute);
            switch (operator) {
                case LESS_THAN: {
                    return currentIndexedData.lowerKey(value) != null;
                }
                case GREATER_THAN: {
                    return currentIndexedData.higherKey(value) != null;
                }
                case LESS_THAN_EQUAL: {
                    return currentIndexedData.ceilingKey(value) != null;
                }
                case GREATER_THAN_EQUAL: {
                    return currentIndexedData.floorKey(value) != null;
                }
                case EQUAL: {
                    return currentIndexedData.get(value) != null;
                }
                case NOT_EQUAL: {
                    return currentIndexedData.size() > 1;
                }
            }
        }
        throw new OperationNotSupportedException(operator + " not supported for '" + value + "' by " + this.getClass().getName());
    }
}

