/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.core.exception.YAMLConfigManagerException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.log4j.Logger;

public class FileReader {
    private static final Logger LOG = Logger.getLogger(FileReader.class);

    public static String readYAMLConfigFile(Path filePath) throws YAMLConfigManagerException {
        if (!filePath.toFile().exists()) {
            throw new YAMLConfigManagerException("Error while initializing YAML config manager, YAML file does not exist with path '" + filePath.toAbsolutePath().toString() + "'.");
        }
        if (!filePath.toString().endsWith(".yaml")) {
            throw new YAMLConfigManagerException("Error while initializing YAML config manager, file extension 'yaml' expected");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initialize config provider instance from configuration file: " + filePath.toString()));
        }
        try {
            return FileReader.readContent(filePath);
        }
        catch (IOException e) {
            throw new YAMLConfigManagerException("Unable to read config file '" + filePath.toAbsolutePath().toString() + "'.", e);
        }
    }

    private static String readContent(Path filePath) throws IOException {
        byte[] contentBytes = Files.readAllBytes(filePath);
        return new String(contentBytes, StandardCharsets.UTF_8);
    }
}

