/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.query.selector.QuerySelector;
import java.util.ArrayList;

public class OnDemandQueryRuntimeUtil {
    public static Event[] executeSelector(StateEventFactory stateEventFactory, StreamEvent streamEvent, StreamEvent storeEvents, int storeEventIndex, QuerySelector selector) {
        ComplexEventChunk outputComplexEventChunk = OnDemandQueryRuntimeUtil.executeSelectorAndReturnChunk(stateEventFactory, streamEvent, storeEvents, storeEventIndex, selector);
        if (outputComplexEventChunk != null) {
            ArrayList<Event> events = new ArrayList<Event>();
            outputComplexEventChunk.reset();
            while (outputComplexEventChunk.hasNext()) {
                Object complexEvent = outputComplexEventChunk.next();
                events.add(new Event(complexEvent.getTimestamp(), complexEvent.getOutputData()));
            }
            return events.toArray(new Event[0]);
        }
        return null;
    }

    private static ComplexEventChunk executeSelectorAndReturnChunk(StateEventFactory stateEventFactory, StreamEvent streamEvent, StreamEvent storeEvents, int storeEventIndex, QuerySelector selector) {
        ComplexEventChunk<StateEvent> complexEventChunk = new ComplexEventChunk<StateEvent>(true);
        while (storeEvents != null) {
            StreamEvent storeEvent = storeEvents;
            storeEvents = storeEvents.getNext();
            storeEvent.setNext(null);
            StateEvent joinEvent = stateEventFactory.newInstance();
            if (streamEvent == null) {
                joinEvent.addEvent(storeEventIndex, storeEvent);
            } else {
                joinEvent.addEvent(0, streamEvent);
                joinEvent.addEvent(1, storeEvent);
            }
            complexEventChunk.add(joinEvent);
        }
        return selector.execute(complexEventChunk);
    }

    public static StreamEvent executeSelectorAndReturnStreamEvent(StateEventFactory stateEventFactory, StreamEvent streamEvent, StreamEvent storeEvents, int storeEventIndex, QuerySelector selector) {
        ComplexEventChunk outputComplexEventChunk = OnDemandQueryRuntimeUtil.executeSelectorAndReturnChunk(stateEventFactory, streamEvent, storeEvents, storeEventIndex, selector);
        if (outputComplexEventChunk != null) {
            outputComplexEventChunk.reset();
            Object firstComplexEvent = outputComplexEventChunk.next();
            StreamEvent firstEvent = new StreamEvent(0, 0, firstComplexEvent.getOutputData().length);
            firstEvent.setOutputData(firstComplexEvent.getOutputData());
            StreamEvent eventPointer = firstEvent;
            while (outputComplexEventChunk.hasNext()) {
                Object complexEvent = outputComplexEventChunk.next();
                StreamEvent resultEvent = new StreamEvent(0, 0, complexEvent.getOutputData().length);
                resultEvent.setOutputData(complexEvent.getOutputData());
                eventPointer.setNext(resultEvent);
                eventPointer = resultEvent;
            }
            return firstEvent;
        }
        return null;
    }
}

