/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.cache;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.table.InMemoryTable;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.record.AbstractQueryableRecordTable;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.parser.MatcherParser;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.expression.Expression;
import io.siddhi.query.api.expression.Variable;
import io.siddhi.query.api.expression.condition.Compare;
import io.siddhi.query.api.expression.constant.LongConstant;
import io.siddhi.query.api.expression.math.Subtract;
import java.util.ArrayList;
import java.util.Map;

public class CacheExpirer {
    private InMemoryTable cacheTable;
    private StreamEventFactory streamEventFactory;
    private Map<String, Table> tableMap;
    private AbstractQueryableRecordTable storeTable;
    private SiddhiAppContext siddhiAppContext;
    private long retentionPeriod;
    private CompiledCondition cacheExpiryCompiledCondition;

    public CacheExpirer(long retentionPeriod, InMemoryTable cacheTable, Map<String, Table> tableMap, AbstractQueryableRecordTable storeTable, SiddhiAppContext siddhiAppContext) {
        this.cacheTable = cacheTable;
        this.tableMap = tableMap;
        this.storeTable = storeTable;
        this.siddhiAppContext = siddhiAppContext;
        this.retentionPeriod = retentionPeriod;
        this.cacheExpiryCompiledCondition = this.generateExpiryCompiledCondition();
    }

    private ComplexEventChunk<StateEvent> generateDeleteEventChunk() {
        ComplexEventChunk<StateEvent> deleteEventChunk = new ComplexEventChunk<StateEvent>();
        StateEvent stateEvent = new StateEvent(2, 0);
        StreamEvent deletingEvent = this.streamEventFactory.newInstance();
        deletingEvent.setOutputData(new Object[]{this.siddhiAppContext.getTimestampGenerator().currentTime()});
        stateEvent.addEvent(0, deletingEvent);
        deleteEventChunk.add(stateEvent);
        return deleteEventChunk;
    }

    private CompiledCondition generateExpiryCompiledCondition() {
        MetaStreamEvent tableMetaStreamEvent = new MetaStreamEvent();
        tableMetaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        TableDefinition matchingTableDefinition = TableDefinition.id((String)this.cacheTable.getTableDefinition().getId());
        for (Attribute attribute : this.cacheTable.getTableDefinition().getAttributeList()) {
            tableMetaStreamEvent.addOutputData(attribute);
            matchingTableDefinition.attribute(attribute.getName(), attribute.getType());
        }
        tableMetaStreamEvent.addInputDefinition((AbstractDefinition)matchingTableDefinition);
        this.streamEventFactory = new StreamEventFactory(tableMetaStreamEvent);
        Variable rightExpressionForSubtract = new Variable("_TIMESTAMP_ADDED");
        rightExpressionForSubtract.setStreamId(this.cacheTable.getTableDefinition().getId());
        LongConstant rightExpressionForCompare = new LongConstant(this.retentionPeriod);
        Compare.Operator greaterThanOperator = Compare.Operator.GREATER_THAN;
        MetaStreamEvent currentTimeMetaStreamEvent = new MetaStreamEvent();
        currentTimeMetaStreamEvent.setEventType(MetaStreamEvent.EventType.TABLE);
        Attribute currentTimeAttribute = new Attribute("current.time", Attribute.Type.LONG);
        currentTimeMetaStreamEvent.addOutputData(currentTimeAttribute);
        TableDefinition currentTimeTableDefinition = TableDefinition.id((String)"");
        currentTimeTableDefinition.attribute("current.time", Attribute.Type.LONG);
        currentTimeMetaStreamEvent.addInputDefinition((AbstractDefinition)currentTimeTableDefinition);
        MetaStateEvent metaStateEvent = new MetaStateEvent(2);
        metaStateEvent.addEvent(currentTimeMetaStreamEvent);
        metaStateEvent.addEvent(tableMetaStreamEvent);
        MatchingMetaInfoHolder matchingMetaInfoHolder = MatcherParser.constructMatchingMetaStateHolder(metaStateEvent, 0, (AbstractDefinition)this.cacheTable.getTableDefinition(), 0);
        ArrayList<VariableExpressionExecutor> variableExpressionExecutors = new ArrayList<VariableExpressionExecutor>();
        Variable leftExpressionForSubtract = new Variable("current.time");
        Subtract leftExpressionForCompare = new Subtract((Expression)leftExpressionForSubtract, (Expression)rightExpressionForSubtract);
        Compare deleteCondition = new Compare((Expression)leftExpressionForCompare, greaterThanOperator, (Expression)rightExpressionForCompare);
        SiddhiQueryContext siddhiQueryContext = new SiddhiQueryContext(this.siddhiAppContext, "expiryDeleteQuery");
        return this.cacheTable.compileCondition((Expression)deleteCondition, matchingMetaInfoHolder, variableExpressionExecutors, this.tableMap, siddhiQueryContext);
    }

    public Runnable generateCacheExpirer() {
        class CheckAndExpireCache
        implements Runnable {
            @Override
            public void run() {
                try {
                    CacheExpirer.this.storeTable.handleCacheExpiry(CacheExpirer.this.cacheExpiryCompiledCondition, CacheExpirer.this.generateDeleteEventChunk());
                }
                catch (Exception e) {
                    throw new SiddhiAppRuntimeException(CacheExpirer.this.siddhiAppContext.getName() + ": " + e.getMessage());
                }
            }
        }
        return new CheckAndExpireCache();
    }
}

