/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.executor;

import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import io.siddhi.core.util.collection.expression.CollectionExpression;
import java.util.Collection;
import java.util.HashSet;

public class NonAndCollectionExecutor
implements CollectionExecutor {
    private final CollectionExecutor collectionExecutor;
    private final CollectionExpression.CollectionScope collectionScope;
    private final ExpressionExecutor valueExpressionExecutor;

    public NonAndCollectionExecutor(ExpressionExecutor valueExpressionExecutor, CollectionExecutor aCollectionExecutor, CollectionExpression.CollectionScope collectionScope) {
        this.valueExpressionExecutor = valueExpressionExecutor;
        this.collectionExecutor = aCollectionExecutor;
        this.collectionScope = collectionScope;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        if (((Boolean)this.valueExpressionExecutor.execute(matchingEvent)).booleanValue()) {
            return this.collectionExecutor.find(matchingEvent, indexedEventHolder, storeEventCloner);
        }
        return null;
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        if (((Boolean)this.valueExpressionExecutor.execute(matchingEvent)).booleanValue()) {
            switch (this.collectionScope) {
                case NON: 
                case INDEXED_ATTRIBUTE: 
                case INDEXED_RESULT_SET: 
                case OPTIMISED_PRIMARY_KEY_OR_INDEXED_RESULT_SET: {
                    return this.collectionExecutor.findEvents(matchingEvent, indexedEventHolder);
                }
                case EXHAUSTIVE: {
                    return null;
                }
            }
        } else {
            return new HashSet<StreamEvent>();
        }
        return null;
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return (Boolean)this.valueExpressionExecutor.execute(matchingEvent) != false && this.collectionExecutor.contains(matchingEvent, indexedEventHolder);
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        if (((Boolean)this.valueExpressionExecutor.execute(deletingEvent)).booleanValue()) {
            this.collectionExecutor.delete(deletingEvent, indexedEventHolder);
        }
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        if (this.collectionScope == CollectionExpression.CollectionScope.EXHAUSTIVE) {
            return CollectionExecutor.Cost.EXHAUSTIVE;
        }
        return this.collectionExecutor.getDefaultCost();
    }
}

