/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.executor;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.table.holder.IndexedEventHolder;
import io.siddhi.core.util.collection.executor.CollectionExecutor;
import java.util.Collection;
import java.util.HashSet;

public class OrCollectionExecutor
implements CollectionExecutor {
    private final CollectionExecutor rightCollectionExecutor;
    private final CollectionExecutor leftCollectionExecutor;
    private CollectionExecutor exhaustiveCollectionExecutor;

    public OrCollectionExecutor(CollectionExecutor leftCollectionExecutor, CollectionExecutor rightCollectionExecutor, CollectionExecutor exhaustiveCollectionExecutor) {
        this.leftCollectionExecutor = leftCollectionExecutor;
        this.rightCollectionExecutor = rightCollectionExecutor;
        this.exhaustiveCollectionExecutor = exhaustiveCollectionExecutor;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        Collection<StreamEvent> leftStreamEvents = this.leftCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (leftStreamEvents == null) {
            return this.exhaustiveCollectionExecutor.find(matchingEvent, indexedEventHolder, storeEventCloner);
        }
        Collection<StreamEvent> rightStreamEvents = this.rightCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (rightStreamEvents == null) {
            return this.exhaustiveCollectionExecutor.find(matchingEvent, indexedEventHolder, storeEventCloner);
        }
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        for (StreamEvent resultEvent : leftStreamEvents) {
            if (storeEventCloner != null) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(resultEvent));
                continue;
            }
            returnEventChunk.add(resultEvent);
        }
        for (StreamEvent resultEvent : rightStreamEvents) {
            if (leftStreamEvents.contains(resultEvent)) continue;
            if (storeEventCloner != null) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(resultEvent));
                continue;
            }
            returnEventChunk.add(resultEvent);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> leftStreamEvents = this.leftCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (leftStreamEvents == null) {
            return null;
        }
        Collection<StreamEvent> rightStreamEvents = this.rightCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (rightStreamEvents == null) {
            return null;
        }
        HashSet<StreamEvent> resultSet = new HashSet<StreamEvent>(leftStreamEvents);
        resultSet.addAll(rightStreamEvents);
        return resultSet;
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> leftStreamEvents = this.leftCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (leftStreamEvents != null && leftStreamEvents.size() > 0) {
            return true;
        }
        Collection<StreamEvent> rightStreamEvents = this.rightCollectionExecutor.findEvents(matchingEvent, indexedEventHolder);
        if (rightStreamEvents != null && rightStreamEvents.size() > 0) {
            return true;
        }
        return this.exhaustiveCollectionExecutor.contains(matchingEvent, indexedEventHolder);
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        Collection<StreamEvent> leftStreamEvents = this.leftCollectionExecutor.findEvents(deletingEvent, indexedEventHolder);
        if (leftStreamEvents == null) {
            this.exhaustiveCollectionExecutor.delete(deletingEvent, indexedEventHolder);
        } else {
            Collection<StreamEvent> rightStreamEvents = this.rightCollectionExecutor.findEvents(deletingEvent, indexedEventHolder);
            if (rightStreamEvents == null) {
                this.exhaustiveCollectionExecutor.delete(deletingEvent, indexedEventHolder);
            } else {
                this.leftCollectionExecutor.delete(deletingEvent, indexedEventHolder);
                this.rightCollectionExecutor.delete(deletingEvent, indexedEventHolder);
            }
        }
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        CollectionExecutor.Cost leftCost = this.leftCollectionExecutor.getDefaultCost();
        CollectionExecutor.Cost rightCost = this.rightCollectionExecutor.getDefaultCost();
        if (leftCost.getWeight() < rightCost.getWeight()) {
            return rightCost;
        }
        return leftCost;
    }
}

