/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.config;

import io.siddhi.core.util.config.ConfigReader;
import java.util.HashMap;
import java.util.Map;

public class InMemoryConfigReader
implements ConfigReader {
    private final String keyPrefix;
    private final Map<String, String> configs;

    public InMemoryConfigReader(String keyPrefix, Map<String, String> configs) {
        this.keyPrefix = keyPrefix;
        this.configs = configs;
    }

    @Override
    public String readConfig(String name, String defaultValue) {
        String value = this.configs.get(this.keyPrefix + "." + name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Map<String, String> getAllConfigs() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> config : this.configs.entrySet()) {
            if (!config.getKey().startsWith(this.keyPrefix + ".")) continue;
            map.put(config.getKey().replaceFirst(this.keyPrefix + ".", ""), config.getValue());
        }
        return map;
    }
}

