/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.config;

import io.siddhi.core.exception.YAMLConfigManagerException;
import io.siddhi.core.util.config.ConfigManager;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.config.YAMLConfigReader;
import io.siddhi.core.util.config.model.Extension;
import io.siddhi.core.util.config.model.ExtensionChildConfiguration;
import io.siddhi.core.util.config.model.Reference;
import io.siddhi.core.util.config.model.ReferenceChildConfiguration;
import io.siddhi.core.util.config.model.RootConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class YAMLConfigManager
implements ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(YAMLConfigManager.class);
    private RootConfiguration rootConfiguration;

    public YAMLConfigManager(String yamlContent) {
        this.init(yamlContent);
    }

    private void init(String yamlContent) throws YAMLConfigManagerException {
        try {
            CustomClassLoaderConstructor constructor = new CustomClassLoaderConstructor(RootConfiguration.class, RootConfiguration.class.getClassLoader());
            PropertyUtils propertyUtils = new PropertyUtils();
            propertyUtils.setSkipMissingProperties(true);
            constructor.setPropertyUtils(propertyUtils);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            yaml.setBeanAccess(BeanAccess.FIELD);
            this.rootConfiguration = (RootConfiguration)yaml.load(yamlContent);
        }
        catch (Exception e) {
            throw new YAMLConfigManagerException("Unable to parse YAML string, '" + yamlContent + "'.", e);
        }
    }

    @Override
    public ConfigReader generateConfigReader(String namespace, String name) {
        for (Extension extension : this.rootConfiguration.getExtensions()) {
            ExtensionChildConfiguration childConfiguration = extension.getExtension();
            if (!childConfiguration.getNamespace().equals(namespace) || !childConfiguration.getName().equals(name)) continue;
            return new YAMLConfigReader(childConfiguration.getProperties());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not find a matching configuration for name: " + name + "and namespace: " + namespace + "!");
        }
        return new YAMLConfigReader(new HashMap<String, String>());
    }

    @Override
    public Map<String, String> extractSystemConfigs(String name) {
        for (Reference reference : this.rootConfiguration.getRefs()) {
            ReferenceChildConfiguration childConf = reference.getReference();
            if (!childConf.getName().equals(name)) continue;
            HashMap<String, String> referenceConfigs = new HashMap<String, String>();
            referenceConfigs.put("type", childConf.getType());
            referenceConfigs.putAll(childConf.getProperties());
            return referenceConfigs;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not find a matching reference for name: '" + name + "'!");
        }
        return new HashMap<String, String>();
    }

    @Override
    public String extractProperty(String name) {
        String property = this.rootConfiguration.getProperties().get(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not find a matching configuration for property name: " + name + "");
        }
        return property;
    }
}

