/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.extension.validator;

import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.executor.ConstantExpressionExecutor;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.util.parser.helper.AnnotationHelper;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class InputParameterValidator {
    public static void validateExpressionExecutors(Object objectHavingAnnotation, ExpressionExecutor[] attributeExpressionExecutors) throws SiddhiAppValidationException {
        Extension annotation = objectHavingAnnotation.getClass().getAnnotation(Extension.class);
        if (annotation == null) {
            return;
        }
        ParameterOverload[] parameterOverloads = annotation.parameterOverloads();
        Parameter[] parameters = annotation.parameters();
        String key = AnnotationHelper.createAnnotationKey(annotation);
        int mandatoryCount = 0;
        HashMap<String, Parameter> parameterMap = new HashMap<String, Parameter>();
        for (Parameter parameter : parameters) {
            if (!parameter.optional()) {
                ++mandatoryCount;
            }
            parameterMap.put(parameter.name(), parameter);
        }
        ParameterOverload parameterOverload = null;
        for (ParameterOverload aParameterOverload : parameterOverloads) {
            boolean supportedReturnType;
            int i;
            boolean isExpectedParameterOverload;
            String[] overloadParameterNames = aParameterOverload.parameterNames();
            if (!(overloadParameterNames.length != attributeExpressionExecutors.length || overloadParameterNames.length != 0 && overloadParameterNames[overloadParameterNames.length - 1].equals("..."))) {
                isExpectedParameterOverload = true;
                for (i = 0; i < overloadParameterNames.length; ++i) {
                    String overloadParameterName = overloadParameterNames[i];
                    Parameter parameter = (Parameter)parameterMap.get(overloadParameterName);
                    supportedReturnType = false;
                    for (DataType type : parameter.type()) {
                        if (!attributeExpressionExecutors[i].getReturnType().toString().equalsIgnoreCase(type.toString())) continue;
                        supportedReturnType = true;
                        break;
                    }
                    if (supportedReturnType) continue;
                    isExpectedParameterOverload = false;
                    break;
                }
                if (!isExpectedParameterOverload) continue;
                parameterOverload = aParameterOverload;
                break;
            }
            if (overloadParameterNames.length - 1 > attributeExpressionExecutors.length || overloadParameterNames.length <= 0 || !overloadParameterNames[overloadParameterNames.length - 1].equals("...") || attributeExpressionExecutors.length <= 0) continue;
            isExpectedParameterOverload = true;
            for (i = 0; i < attributeExpressionExecutors.length; ++i) {
                Parameter parameter = null;
                String overloadParameterName = null;
                overloadParameterName = i < overloadParameterNames.length - 1 ? overloadParameterNames[i] : overloadParameterNames[overloadParameterNames.length - 2];
                parameter = (Parameter)parameterMap.get(overloadParameterName);
                supportedReturnType = false;
                for (DataType type : parameter.type()) {
                    if (!attributeExpressionExecutors[i].getReturnType().toString().equalsIgnoreCase(type.toString())) continue;
                    supportedReturnType = true;
                    break;
                }
                if (supportedReturnType) continue;
                isExpectedParameterOverload = false;
                break;
            }
            if (!isExpectedParameterOverload) continue;
            parameterOverload = aParameterOverload;
            break;
        }
        if (parameterOverload == null) {
            if (parameterOverloads.length > 0) {
                ArrayList<Attribute.Type> returnTypes = new ArrayList<Attribute.Type>();
                for (ExpressionExecutor expressionExecutor : attributeExpressionExecutors) {
                    returnTypes.add(expressionExecutor.getReturnType());
                }
                String formattedParamOverloadString = InputParameterValidator.getSupportedParamOverloads(parameterMap, parameterOverloads);
                throw new SiddhiAppValidationException("There is no parameterOverload for '" + key + "' that matches attribute types '" + returnTypes.stream().map(String::valueOf).collect(Collectors.joining(", ", "<", ">")) + "'. Supported parameter overloads are " + formattedParamOverloadString + ".");
            }
            if (mandatoryCount > attributeExpressionExecutors.length) {
                throw new SiddhiAppValidationException("The '" + key + "' expects at least " + mandatoryCount + " parameters, but found only " + attributeExpressionExecutors.length + " input parameters.");
            }
        } else {
            String[] overloadParameterNames = parameterOverload.parameterNames();
            for (int i = 0; i < overloadParameterNames.length; ++i) {
                String overloadParameterName = overloadParameterNames[i];
                Parameter parameter = (Parameter)parameterMap.get(overloadParameterName);
                if (parameter == null || parameter.dynamic() || attributeExpressionExecutors[i] instanceof ConstantExpressionExecutor) continue;
                throw new SiddhiAppValidationException("The '" + key + "' expects input parameter '" + parameter.name() + "' at position '" + i + "' to be static, but found a dynamic attribute.");
            }
        }
    }

    private static String getSupportedParamOverloads(Map<String, Parameter> parameterMap, ParameterOverload[] parameterOverloads) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (ParameterOverload parameterOverload : parameterOverloads) {
            String[] parameterNames = parameterOverload.parameterNames();
            if (parameterNames.length == 0) continue;
            StringJoiner paramOverloadStringJoiner = new StringJoiner(", ", "(", ")");
            for (int i = 0; i < parameterNames.length; ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!"...".equals(parameterNames[i])) {
                    stringBuilder.append(InputParameterValidator.getFormattedStringForDataType(parameterMap.get(parameterNames[i]).type()));
                    stringBuilder.append(" ").append(parameterNames[i]);
                } else {
                    stringBuilder.append(InputParameterValidator.getFormattedStringForDataType(parameterMap.get(parameterNames[i - 1]).type()));
                    stringBuilder.append(" ").append("...");
                }
                paramOverloadStringJoiner.add(stringBuilder);
            }
            stringJoiner.add(paramOverloadStringJoiner.toString());
        }
        return stringJoiner.toString();
    }

    private static String getFormattedStringForDataType(DataType[] dataTypes) {
        StringJoiner stringJoiner = new StringJoiner("|", "<", ">");
        for (DataType dataType : dataTypes) {
            stringJoiner.add(dataType.name());
        }
        return stringJoiner.toString();
    }
}

