/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.lock;

import io.siddhi.core.util.lock.LockWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class LockSynchronizer {
    private Map<LockWrapper, List<LockWrapper>> holderMap = new HashMap<LockWrapper, List<LockWrapper>>();

    public void sync(LockWrapper lockWrapperOne, LockWrapper lockWrapperTwo) {
        boolean leftHolderExists = this.holderMap.containsKey(lockWrapperOne);
        boolean rightHolderExists = this.holderMap.containsKey(lockWrapperTwo);
        if (leftHolderExists && !rightHolderExists) {
            lockWrapperTwo.setLock(lockWrapperOne.getLock());
            ArrayList<LockWrapper> connectedLockWrappers = new ArrayList<LockWrapper>();
            connectedLockWrappers.add(lockWrapperOne);
            this.holderMap.put(lockWrapperTwo, connectedLockWrappers);
            this.holderMap.get(lockWrapperOne).add(lockWrapperTwo);
        } else if (!leftHolderExists && rightHolderExists) {
            lockWrapperOne.setLock(lockWrapperTwo.getLock());
            ArrayList<LockWrapper> connectedLockWrappers = new ArrayList<LockWrapper>();
            connectedLockWrappers.add(lockWrapperTwo);
            this.holderMap.put(lockWrapperOne, connectedLockWrappers);
            this.holderMap.get(lockWrapperTwo).add(lockWrapperOne);
        } else if (!leftHolderExists && !rightHolderExists) {
            ReentrantLock lock = new ReentrantLock();
            lockWrapperOne.setLock(lock);
            lockWrapperTwo.setLock(lock);
            ArrayList<LockWrapper> connectedWrappersOfOne = new ArrayList<LockWrapper>();
            ArrayList<LockWrapper> connectedWrappersOfTwo = new ArrayList<LockWrapper>();
            connectedWrappersOfOne.add(lockWrapperTwo);
            connectedWrappersOfTwo.add(lockWrapperOne);
            this.holderMap.put(lockWrapperOne, connectedWrappersOfOne);
            this.holderMap.put(lockWrapperTwo, connectedWrappersOfTwo);
        } else {
            ReentrantLock lockOfWrapperOne = lockWrapperOne.getLock();
            lockWrapperTwo.setLock(lockOfWrapperOne);
            List<LockWrapper> rightList = this.holderMap.get(lockWrapperTwo);
            for (LockWrapper holder : rightList) {
                holder.setLock(lockOfWrapperOne);
            }
        }
    }
}

