/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.debugger;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.debugger.SiddhiDebuggerCallback;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.util.snapshot.SnapshotService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class SiddhiDebugger {
    private static final Logger log = Logger.getLogger(SiddhiDebugger.class);
    private static final ThreadLocal<Boolean> threadLocalNextFlag = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private Semaphore breakPointLock = new Semaphore(0);
    private HashMap<String, AtomicBoolean> acquiredBreakPointsMap = new HashMap();
    private volatile AtomicBoolean enableNext = new AtomicBoolean(false);
    private SiddhiDebuggerCallback siddhiDebuggerCallback;
    private SnapshotService snapshotService;

    public SiddhiDebugger(SiddhiAppContext siddhiAppContext) {
        this.snapshotService = siddhiAppContext.getSnapshotService();
    }

    public void acquireBreakPoint(String queryName, QueryTerminal queryTerminal) {
        String breakpointName = this.createBreakpointName(queryName, queryTerminal);
        AtomicBoolean breakPointLock = this.acquiredBreakPointsMap.get(breakpointName);
        if (breakPointLock == null) {
            breakPointLock = new AtomicBoolean(true);
            this.acquiredBreakPointsMap.put(breakpointName, breakPointLock);
        } else {
            breakPointLock.set(true);
        }
    }

    public void releaseBreakPoint(String queryName, QueryTerminal queryTerminal) {
        this.acquiredBreakPointsMap.remove(this.createBreakpointName(queryName, queryTerminal));
    }

    public void releaseAllBreakPoints() {
        this.acquiredBreakPointsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBreakPoint(String queryName, QueryTerminal queryTerminal, ComplexEvent complexEvent) {
        SiddhiDebugger siddhiDebugger = this;
        synchronized (siddhiDebugger) {
            String breakpointName = this.createBreakpointName(queryName, queryTerminal);
            AtomicBoolean breakpoint = this.acquiredBreakPointsMap.get(breakpointName);
            boolean isNext = this.isNextEnabled();
            if (isNext) {
                this.setNextEnabled(false);
            }
            if (breakpoint != null && breakpoint.get() || isNext) {
                if (this.siddhiDebuggerCallback != null) {
                    this.siddhiDebuggerCallback.debugEvent(complexEvent, queryName, queryTerminal, this);
                }
                try {
                    this.breakPointLock.acquire();
                    if (this.enableNext.get()) {
                        this.setNextEnabled(true);
                        this.enableNext.set(false);
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)("Error in acquiring breakpoint lock at " + breakpointName));
                }
            }
        }
    }

    public void next() {
        this.enableNext.set(true);
        this.breakPointLock.release();
    }

    public void play() {
        this.breakPointLock.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebuggerCallback(SiddhiDebuggerCallback siddhiDebuggerCallback) {
        SiddhiDebugger siddhiDebugger = this;
        synchronized (siddhiDebugger) {
            this.siddhiDebuggerCallback = siddhiDebuggerCallback;
        }
    }

    public Map<String, Object> getQueryState(String queryName) {
        return this.snapshotService.queryState(queryName);
    }

    private boolean isNextEnabled() {
        return threadLocalNextFlag.get();
    }

    private void setNextEnabled(boolean nextEnabled) {
        threadLocalNextFlag.set(nextEnabled);
    }

    private String createBreakpointName(String queryName, QueryTerminal queryTerminal) {
        return queryName + ":" + (Object)((Object)queryTerminal);
    }

    public static enum QueryTerminal {
        IN,
        OUT;

    }
}

