/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event;

import io.siddhi.core.event.ComplexEvent;
import java.util.Arrays;

public class Event {
    protected long timestamp = -1L;
    protected Object[] data;
    protected boolean isExpired = false;

    public Event(long timestamp, Object[] data) {
        this.timestamp = timestamp;
        this.data = data;
    }

    public Event() {
        this.data = new Object[0];
    }

    public Event(int dataSize) {
        this.data = new Object[dataSize];
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Object[] getData() {
        return this.data;
    }

    public void setData(Object[] data) {
        this.data = data;
    }

    public Object getData(int i) {
        return this.data[i];
    }

    public boolean isExpired() {
        return this.isExpired;
    }

    public String toString() {
        return "Event{timestamp=" + this.timestamp + ", data=" + Arrays.toString(this.data) + ", isExpired=" + this.isExpired + '}';
    }

    public void setIsExpired(Boolean isExpired) {
        this.isExpired = isExpired;
    }

    public Event copyFrom(Event event) {
        this.timestamp = event.timestamp;
        System.arraycopy(event.data, 0, this.data, 0, this.data.length);
        this.isExpired = event.isExpired;
        return this;
    }

    public Event copyFrom(ComplexEvent complexEvent) {
        this.timestamp = complexEvent.getTimestamp();
        System.arraycopy(complexEvent.getOutputData(), 0, this.data, 0, this.data.length);
        this.isExpired = complexEvent.getType() == ComplexEvent.Type.EXPIRED;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        if (this.isExpired != event.isExpired) {
            return false;
        }
        if (this.timestamp != event.timestamp) {
            return false;
        }
        return Arrays.equals(this.data, event.data);
    }

    public int hashCode() {
        int result = (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.data != null ? Arrays.hashCode(this.data) : 0);
        result = 31 * result + (this.isExpired ? 1 : 0);
        return result;
    }
}

