/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream;

import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;

public class StreamEventCloner {
    private final int beforeWindowDataSize;
    private final int onAfterWindowDataSize;
    private final int outputDataSize;
    private final StreamEventFactory eventFactory;

    public StreamEventCloner(MetaStreamEvent metaStreamEvent, StreamEventFactory eventFactory) {
        this.eventFactory = eventFactory;
        this.beforeWindowDataSize = metaStreamEvent.getBeforeWindowData().size();
        this.onAfterWindowDataSize = metaStreamEvent.getOnAfterWindowData().size();
        this.outputDataSize = metaStreamEvent.getOutputData().size();
    }

    public StreamEvent copyStreamEvent(StreamEvent streamEvent) {
        StreamEvent newEvent = this.eventFactory.newInstance();
        if (this.beforeWindowDataSize > 0) {
            System.arraycopy(streamEvent.getBeforeWindowData(), 0, newEvent.getBeforeWindowData(), 0, this.beforeWindowDataSize);
        }
        if (this.onAfterWindowDataSize > 0) {
            System.arraycopy(streamEvent.getOnAfterWindowData(), 0, newEvent.getOnAfterWindowData(), 0, this.onAfterWindowDataSize);
        }
        if (this.outputDataSize > 0) {
            System.arraycopy(streamEvent.getOutputData(), 0, newEvent.getOutputData(), 0, this.outputDataSize);
        }
        newEvent.setType(streamEvent.getType());
        newEvent.setTimestamp(streamEvent.getTimestamp());
        return newEvent;
    }
}

