/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.event.stream.converter;

import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.Event;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.converter.StreamEventConverter;
import java.io.Serializable;
import java.util.List;

public class SelectiveStreamEventConverter
implements StreamEventConverter,
Serializable {
    private static final long serialVersionUID = 5728843379822962369L;
    private List<StreamEventConverter.ConversionMapping> conversionMappings;

    public SelectiveStreamEventConverter(List<StreamEventConverter.ConversionMapping> conversionMappings) {
        this.conversionMappings = conversionMappings;
    }

    @Override
    public void convertData(long timestamp, Object[] data, ComplexEvent.Type type, StreamEvent newEvent) {
        for (StreamEventConverter.ConversionMapping conversionMapping : this.conversionMappings) {
            int[] position = conversionMapping.getToPosition();
            int fromPosition = conversionMapping.getFromPosition();
            switch (position[0]) {
                case 0: {
                    newEvent.setBeforeWindowData(data[fromPosition], position[1]);
                    break;
                }
                case 1: {
                    newEvent.setOnAfterWindowData(data[fromPosition], position[1]);
                    break;
                }
                case 2: {
                    newEvent.setOutputData(data[fromPosition], position[1]);
                    break;
                }
            }
        }
        newEvent.setType(type);
        newEvent.setTimestamp(timestamp);
    }

    @Override
    public void convertEvent(Event event, StreamEvent newEvent) {
        this.convertData(event.getTimestamp(), event.getData(), event.isExpired() ? ComplexEvent.Type.EXPIRED : ComplexEvent.Type.CURRENT, newEvent);
    }

    @Override
    public void convertComplexEvent(ComplexEvent complexEvent, StreamEvent newEvent) {
        this.convertData(complexEvent.getTimestamp(), complexEvent.getOutputData(), complexEvent.getType(), newEvent);
    }

    @Override
    public void convertData(long timeStamp, Object[] data, StreamEvent newEvent) {
        this.convertData(timeStamp, data, ComplexEvent.Type.CURRENT, newEvent);
    }
}

