/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.input.stream.state;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.query.input.stream.state.AbsentPreStateProcessor;
import io.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import io.siddhi.core.util.Scheduler;
import io.siddhi.query.api.execution.query.input.stream.StateInputStream;
import java.util.Iterator;
import java.util.Map;

public class AbsentStreamPreStateProcessor
extends StreamPreStateProcessor
implements AbsentPreStateProcessor {
    private Scheduler scheduler;
    private long waitingTime = -1L;

    public AbsentStreamPreStateProcessor(StateInputStream.Type stateType, long waitingTime) {
        super(stateType);
        this.waitingTime = waitingTime;
    }

    @Override
    public void init(SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), false, () -> new LogicalStreamPreState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastArrivalTime(long timestamp) {
        LogicalStreamPreState state = (LogicalStreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            state.lastScheduledTime = timestamp + this.waitingTime;
            this.scheduler.notifyAt(state.lastScheduledTime);
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addState(StateEvent stateEvent, StreamPreStateProcessor.StreamPreState preState) {
        LogicalStreamPreState state = (LogicalStreamPreState)preState;
        if (!state.active) {
            return;
        }
        this.lock.lock();
        try {
            if (this.stateType == StateInputStream.Type.SEQUENCE) {
                state.getNewAndEveryStateEventList().clear();
                state.getNewAndEveryStateEventList().add(stateEvent);
            } else {
                state.getNewAndEveryStateEventList().add(stateEvent);
            }
            if (!this.isStartState) {
                state.lastScheduledTime = stateEvent.getTimestamp() + this.waitingTime;
                this.scheduler.notifyAt(state.lastScheduledTime);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEveryState(StateEvent stateEvent) {
        LogicalStreamPreState state = (LogicalStreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
            clonedEvent.setType(ComplexEvent.Type.CURRENT);
            for (int i = this.stateId; i < clonedEvent.getStreamEvents().length; ++i) {
                clonedEvent.setEvent(i, null);
            }
            state.getNewAndEveryStateEventList().add(clonedEvent);
            state.lastScheduledTime = stateEvent.getTimestamp() + this.waitingTime;
            this.scheduler.notifyAt(state.lastScheduledTime);
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public void resetState() {
        LogicalStreamPreState state = (LogicalStreamPreState)this.stateHolder.getState();
        this.lock.lock();
        try {
            state.getPendingStateEventList().clear();
            if (this.isStartState) {
                if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && !((StreamPreStateProcessor)this.thisStatePostProcessor.nextStatePreProcessor).getPendingStateEventList().isEmpty()) {
                    return;
                }
                this.init();
            }
        }
        finally {
            this.lock.unlock();
            this.stateHolder.returnState(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        LogicalStreamPreState state = (LogicalStreamPreState)this.stateHolder.getState();
        try {
            if (!state.active) {
                return;
            }
            boolean notProcessed = true;
            long currentTime = complexEventChunk.getFirst().getTimestamp();
            ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>(false);
            this.lock.lock();
            try {
                boolean initialize;
                boolean bl = initialize = this.isStartState && state.getNewAndEveryStateEventList().isEmpty() && state.getPendingStateEventList().isEmpty();
                if (initialize && this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && state.lastScheduledTime > 0L) {
                    initialize = false;
                }
                if (initialize) {
                    StateEvent stateEvent = this.stateEventFactory.newInstance();
                    this.addState(stateEvent);
                } else if (this.stateType == StateInputStream.Type.SEQUENCE && !state.getNewAndEveryStateEventList().isEmpty()) {
                    this.resetState();
                }
                this.updateState();
                Iterator iterator = state.getPendingStateEventList().iterator();
                while (iterator.hasNext()) {
                    StateEvent event = (StateEvent)iterator.next();
                    if (this.isExpired(event, currentTime)) {
                        iterator.remove();
                        if (this.withinEveryPreStateProcessor == null || this.thisStatePostProcessor.nextEveryStatePreProcessor == this) continue;
                        this.thisStatePostProcessor.nextEveryStatePreProcessor.addEveryState(event);
                        continue;
                    }
                    if ((event.getTimestamp() != -1L || currentTime < state.lastScheduledTime) && (event.getTimestamp() == -1L || currentTime < event.getTimestamp() + this.waitingTime)) continue;
                    iterator.remove();
                    event.setTimestamp(currentTime);
                    retEventChunk.add(event);
                }
                if (this.withinEveryPreStateProcessor != null) {
                    this.withinEveryPreStateProcessor.updateState();
                }
            }
            finally {
                this.lock.unlock();
            }
            boolean bl = notProcessed = retEventChunk.getFirst() == null;
            while (retEventChunk.hasNext()) {
                StateEvent stateEvent = (StateEvent)retEventChunk.next();
                retEventChunk.remove();
                this.sendEvent(stateEvent, state);
            }
            long actualCurrentTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime();
            if (actualCurrentTime > this.waitingTime + currentTime) {
                state.lastScheduledTime = actualCurrentTime + this.waitingTime;
            }
            if (notProcessed && state.lastScheduledTime < currentTime) {
                state.lastScheduledTime = currentTime + this.waitingTime;
                this.scheduler.notifyAt(state.lastScheduledTime);
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    private void sendEvent(StateEvent stateEvent, LogicalStreamPreState state) {
        if (this.thisStatePostProcessor.nextProcessor != null) {
            this.thisStatePostProcessor.nextProcessor.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, false));
        }
        if (this.thisStatePostProcessor.nextStatePreProcessor != null) {
            this.thisStatePostProcessor.nextStatePreProcessor.addState(stateEvent);
        }
        if (this.thisStatePostProcessor.nextEveryStatePreProcessor != null) {
            this.thisStatePostProcessor.nextEveryStatePreProcessor.addEveryState(stateEvent);
        } else if (this.isStartState) {
            state.active = false;
        }
        if (this.thisStatePostProcessor.callbackPreStateProcessor != null) {
            this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        LogicalStreamPreState state = (LogicalStreamPreState)this.stateHolder.getState();
        try {
            if (!state.active) {
                ComplexEventChunk<StateEvent> complexEventChunk2 = new ComplexEventChunk<StateEvent>(false);
                return complexEventChunk2;
            }
            ComplexEventChunk<StateEvent> event = super.processAndReturn(complexEventChunk);
            StateEvent firstEvent = event.getFirst();
            if (firstEvent != null) {
                event = new ComplexEventChunk(false);
            }
            ComplexEventChunk<StateEvent> complexEventChunk3 = event;
            return complexEventChunk3;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Override
    protected boolean removeOnNoStateChange(StateInputStream.Type stateType) {
        return false;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void partitionCreated() {
        LogicalStreamPreState state = (LogicalStreamPreState)this.stateHolder.getState();
        try {
            if (!state.isStarted()) {
                state.started();
                if (this.isStartState && this.waitingTime != -1L && state.active) {
                    state.lastScheduledTime = this.siddhiQueryContext.getSiddhiAppContext().getTimestampGenerator().currentTime() + this.waitingTime;
                    this.scheduler.notifyAt(state.lastScheduledTime);
                }
            }
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    class LogicalStreamPreState
    extends StreamPreStateProcessor.StreamPreState {
        private long lastScheduledTime;
        private boolean active;

        LogicalStreamPreState() {
            super(AbsentStreamPreStateProcessor.this);
            this.active = true;
        }

        @Override
        public boolean canDestroy() {
            return super.canDestroy();
        }

        @Override
        public Map<String, Object> snapshot() {
            Map<String, Object> snapshot = super.snapshot();
            snapshot.put("IsActive", this.active);
            snapshot.put("LastScheduledTime", this.lastScheduledTime);
            return snapshot;
        }

        @Override
        public void restore(Map<String, Object> state) {
            super.restore(state);
            this.active = (Boolean)state.get("IsActive");
            this.lastScheduledTime = (Long)state.get("LastScheduledTime");
        }
    }
}

