/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.callback;

import io.siddhi.core.debugger.SiddhiDebugger;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.event.stream.converter.StreamEventConverter;

public abstract class OutputCallback {
    private String queryName;
    private SiddhiDebugger siddhiDebugger;

    OutputCallback(String queryName) {
        this.queryName = queryName;
    }

    public abstract void send(ComplexEventChunk var1, int var2);

    SiddhiDebugger getSiddhiDebugger() {
        return this.siddhiDebugger;
    }

    public void setSiddhiDebugger(SiddhiDebugger siddhiDebugger) {
        this.siddhiDebugger = siddhiDebugger;
    }

    String getQueryName() {
        return this.queryName;
    }

    protected ComplexEventChunk<StateEvent> constructMatchingStateEventChunk(ComplexEventChunk matchingComplexEventChunk, boolean convertToStreamEvent, StateEventFactory stateEventFactory, int matchingStreamIndex, StreamEventFactory streamEventFactory, StreamEventConverter streamEventConverter) {
        ComplexEventChunk<StateEvent> stateEventChunk = new ComplexEventChunk<StateEvent>(matchingComplexEventChunk.isBatch());
        while (matchingComplexEventChunk.hasNext()) {
            Object matchingComplexEvent = matchingComplexEventChunk.next();
            matchingComplexEventChunk.remove();
            StateEvent stateEvent = stateEventFactory.newInstance();
            if (convertToStreamEvent) {
                StreamEvent borrowEvent = streamEventFactory.newInstance();
                streamEventConverter.convertData(matchingComplexEvent.getTimestamp(), matchingComplexEvent.getOutputData(), matchingComplexEvent.getType() == ComplexEvent.Type.EXPIRED ? ComplexEvent.Type.CURRENT : matchingComplexEvent.getType(), borrowEvent);
                stateEvent.addEvent(matchingStreamIndex, borrowEvent);
            } else {
                stateEvent.addEvent(matchingStreamIndex, (StreamEvent)matchingComplexEvent);
            }
            stateEventChunk.add(stateEvent);
        }
        return stateEventChunk;
    }
}

