/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEvent;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.partition.PartitionCreationListener;
import io.siddhi.core.query.input.MultiProcessStreamReceiver;
import io.siddhi.core.query.output.callback.OutputCallback;
import io.siddhi.core.query.output.callback.QueryCallback;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.core.util.statistics.LatencyTracker;
import io.siddhi.core.util.statistics.metrics.Level;
import java.util.ArrayList;
import java.util.List;

public abstract class OutputRateLimiter<S extends State>
implements PartitionCreationListener {
    protected List<QueryCallback> queryCallbacks = new ArrayList<QueryCallback>();
    protected OutputCallback outputCallback = null;
    protected LatencyTracker latencyTracker;
    protected SiddhiQueryContext siddhiQueryContext;
    protected LockWrapper lockWrapper;
    protected StateHolder<S> stateHolder;
    private boolean hasCallBack = false;

    public void init(LockWrapper lockWrapper, boolean groupBy, SiddhiQueryContext siddhiQueryContext) {
        this.siddhiQueryContext = siddhiQueryContext;
        if (this.outputCallback != null) {
            this.lockWrapper = lockWrapper;
        }
        this.latencyTracker = siddhiQueryContext.getLatencyTracker();
        this.stateHolder = siddhiQueryContext.generateStateHolder(this.getClass().getName(), groupBy, this.init());
    }

    protected abstract StateFactory<S> init();

    public void sendToCallBacks(ComplexEventChunk complexEventChunk) {
        MultiProcessStreamReceiver.ReturnEventHolder returnEventHolder = MultiProcessStreamReceiver.getMultiProcessReturn().get();
        if (Level.BASIC.compareTo(this.siddhiQueryContext.getSiddhiAppContext().getRootMetricsLevel()) <= 0 && this.latencyTracker != null) {
            this.latencyTracker.markOut();
        }
        if (returnEventHolder != null) {
            returnEventHolder.setReturnEvents(complexEventChunk);
            return;
        }
        if (this.lockWrapper != null) {
            this.lockWrapper.unlock();
        }
        if (Level.BASIC.compareTo(this.siddhiQueryContext.getSiddhiAppContext().getRootMetricsLevel()) <= 0 && this.latencyTracker != null) {
            this.latencyTracker.markOut();
        }
        if (this.lockWrapper != null) {
            this.lockWrapper.unlock();
        }
        if (!this.queryCallbacks.isEmpty()) {
            for (QueryCallback callback : this.queryCallbacks) {
                callback.receiveStreamEvent(complexEventChunk);
            }
        }
        if (this.outputCallback != null && complexEventChunk.getFirst() != null) {
            complexEventChunk.reset();
            int noOfEvents = 0;
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                if (complexEvent.getType() == ComplexEvent.Type.EXPIRED) {
                    complexEvent.setType(ComplexEvent.Type.CURRENT);
                    ++noOfEvents;
                    continue;
                }
                if (complexEvent.getType() == ComplexEvent.Type.RESET) {
                    complexEventChunk.remove();
                    continue;
                }
                ++noOfEvents;
            }
            if (complexEventChunk.getFirst() != null) {
                this.outputCallback.send(complexEventChunk, noOfEvents);
            }
        }
    }

    public void addQueryCallback(QueryCallback callback) {
        this.queryCallbacks.add(callback);
        this.hasCallBack = true;
    }

    public abstract void process(ComplexEventChunk var1);

    public OutputCallback getOutputCallback() {
        return this.outputCallback;
    }

    public void setOutputCallback(OutputCallback outputCallback) {
        this.outputCallback = outputCallback;
        if (outputCallback != null) {
            this.hasCallBack = true;
        }
    }

    public boolean hasCallBack() {
        return this.hasCallBack;
    }
}

