/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.output.ratelimit.snapshot;

import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.MetaComplexEvent;
import io.siddhi.core.event.state.MetaStateEvent;
import io.siddhi.core.event.state.StateEventCloner;
import io.siddhi.core.event.state.StateEventFactory;
import io.siddhi.core.event.stream.MetaStreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AggregationGroupByWindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AggregationWindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.AllAggregationPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.GroupByPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.PerSnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import io.siddhi.core.query.output.ratelimit.snapshot.WindowedPerSnapshotOutputRateLimiter;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.query.selector.attribute.processor.AttributeProcessor;
import io.siddhi.core.util.lock.LockWrapper;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import java.util.ArrayList;
import java.util.List;

public class WrappedSnapshotOutputRateLimiter<S extends State>
extends OutputRateLimiter<S> {
    private final Long value;
    private final boolean groupBy;
    private final boolean windowed;
    private SiddhiQueryContext siddhiQueryContext;
    private SnapshotOutputRateLimiter outputRateLimiter;
    private List<Integer> aggregateAttributePositionList = new ArrayList<Integer>();

    public WrappedSnapshotOutputRateLimiter(Long value, boolean groupBy, boolean isWindowed, SiddhiQueryContext siddhiQueryContext) {
        this.value = value;
        this.groupBy = groupBy;
        this.windowed = isWindowed;
        this.siddhiQueryContext = siddhiQueryContext;
    }

    public void init(SiddhiQueryContext siddhiQueryContext, LockWrapper lockWrapper) {
        super.init(lockWrapper, this.groupBy, siddhiQueryContext);
        this.outputRateLimiter.setQueryLock(lockWrapper);
    }

    public void init(int outPutAttributeSize, List<AttributeProcessor> attributeProcessorList, MetaComplexEvent metaComplexEvent) {
        for (AttributeProcessor attributeProcessor : attributeProcessorList) {
            if (!(attributeProcessor.getExpressionExecutor() instanceof AttributeAggregatorExecutor)) continue;
            this.aggregateAttributePositionList.add(attributeProcessor.getOutputPosition());
        }
        this.outputRateLimiter = this.windowed ? (this.groupBy ? (outPutAttributeSize == this.aggregateAttributePositionList.size() ? new AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.value, this, this.groupBy, this.siddhiQueryContext) : (this.aggregateAttributePositionList.size() > 0 ? new AggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.value, this.aggregateAttributePositionList, this, this.groupBy, this.siddhiQueryContext) : new WindowedPerSnapshotOutputRateLimiter(this.value, this, this.groupBy, this.siddhiQueryContext))) : (outPutAttributeSize == this.aggregateAttributePositionList.size() ? new AllAggregationPerSnapshotOutputRateLimiter(this.value, this, this.groupBy, this.siddhiQueryContext) : (this.aggregateAttributePositionList.size() > 0 ? new AggregationWindowedPerSnapshotOutputRateLimiter(this.value, this.aggregateAttributePositionList, this, this.groupBy, this.siddhiQueryContext) : new WindowedPerSnapshotOutputRateLimiter(this.value, this, this.groupBy, this.siddhiQueryContext)))) : (this.groupBy ? new GroupByPerSnapshotOutputRateLimiter(this.value, this, this.groupBy, this.siddhiQueryContext) : new PerSnapshotOutputRateLimiter(this.value, this, this.groupBy, this.siddhiQueryContext));
        if (metaComplexEvent instanceof MetaStateEvent) {
            StateEventFactory stateEventFactory = new StateEventFactory((MetaStateEvent)metaComplexEvent);
            this.outputRateLimiter.setStateEventCloner(new StateEventCloner((MetaStateEvent)metaComplexEvent, stateEventFactory));
        } else {
            StreamEventFactory streamEventFactory = new StreamEventFactory((MetaStreamEvent)metaComplexEvent);
            this.outputRateLimiter.setStreamEventCloner(new StreamEventCloner((MetaStreamEvent)metaComplexEvent, streamEventFactory));
        }
    }

    @Override
    public void partitionCreated() {
        this.outputRateLimiter.partitionCreated();
    }

    @Override
    protected StateFactory<S> init() {
        return null;
    }

    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        this.outputRateLimiter.process(complexEventChunk);
    }

    public void passToCallBacks(ComplexEventChunk complexEventChunk) {
        this.sendToCallBacks(complexEventChunk);
    }
}

