/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.query.selector.attribute.aggregator;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.ParameterOverload;
import io.siddhi.annotation.ReturnAttribute;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.exception.OperationNotSupportedException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.query.selector.attribute.aggregator.AttributeAggregatorExecutor;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateFactory;
import io.siddhi.query.api.definition.Attribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@Extension(name="distinctCount", namespace="", description="This returns the count of distinct occurrences for a given arg.", parameters={@Parameter(name="arg", description="The object for which the number of distinct occurences needs to be counted.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING}, dynamic=true)}, parameterOverloads={@ParameterOverload(parameterNames={"arg"})}, returnAttributes={@ReturnAttribute(description="Returns the count of distinct occurrences for a given arg.", type={DataType.LONG})}, examples={@Example(syntax="from fooStream\nselect distinctcount(pageID) as count\ninsert into barStream;", description="distinctcount(pageID) for the following output returns '3' when the available values are as follows.\n \"WEB_PAGE_1\"\n \"WEB_PAGE_1\"\n \"WEB_PAGE_2\"\n \"WEB_PAGE_3\"\n \"WEB_PAGE_1\"\n \"WEB_PAGE_2\"\n The three distinct occurences identified are 'WEB_PAGE_1', 'WEB_PAGE_2', and 'WEB_PAGE_3'.")})
public class DistinctCountAttributeAggregatorExecutor
extends AttributeAggregatorExecutor<AggregatorState> {
    @Override
    protected StateFactory<AggregatorState> init(ExpressionExecutor[] attributeExpressionExecutors, ProcessingMode processingMode, boolean outputExpectsExpiredEvents, ConfigReader configReader, SiddhiQueryContext siddhiQueryContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Distinct count aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        return () -> new AggregatorState();
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }

    @Override
    public Object processAdd(Object data, AggregatorState state) {
        Long preVal = (Long)state.distinctValues.get(data);
        if (preVal != null) {
            preVal = preVal + 1L;
            state.distinctValues.put(data, preVal);
        } else {
            state.distinctValues.put(data, 1L);
        }
        return state.getDistinctCount();
    }

    @Override
    public Object processAdd(Object[] data, AggregatorState state) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data, AggregatorState state) {
        Long preVal;
        Long l = preVal = (Long)state.distinctValues.get(data);
        Long l2 = preVal = Long.valueOf(preVal - 1L);
        if (preVal > 0L) {
            state.distinctValues.put(data, preVal);
        } else {
            state.distinctValues.remove(data);
        }
        return state.getDistinctCount();
    }

    @Override
    public Object processRemove(Object[] data, AggregatorState state) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset(AggregatorState state) {
        state.distinctValues.clear();
        return state.getDistinctCount();
    }

    class AggregatorState
    extends State {
        private Map<Object, Long> distinctValues = new HashMap<Object, Long>();

        AggregatorState() {
        }

        @Override
        public boolean canDestroy() {
            return this.distinctValues.isEmpty();
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("DistinctValues", this.distinctValues);
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.distinctValues = (Map)state.get("DistinctValues");
        }

        protected long getDistinctCount() {
            return this.distinctValues.size();
        }
    }
}

