/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.stream.output.sink;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.stream.output.StreamCallback;
import io.siddhi.core.stream.output.sink.Sink;
import io.siddhi.query.api.definition.AbstractDefinition;
import java.util.List;
import org.apache.log4j.Logger;

public class SinkCallback
extends StreamCallback {
    private static final Logger log = Logger.getLogger(SinkCallback.class);
    private AbstractDefinition outputStreamDefinition;
    private List<Sink> sinks;

    public SinkCallback(List<Sink> sinks, AbstractDefinition outputStreamDefinition) {
        this.sinks = sinks;
        this.outputStreamDefinition = outputStreamDefinition;
    }

    public void init(SiddhiAppContext siddhiAppContext) {
    }

    @Override
    public void receive(Event event) {
        if (event != null) {
            for (Sink sink : this.sinks) {
                if (sink.getHandler() != null) {
                    sink.getHandler().handle(event);
                    continue;
                }
                sink.getMapper().mapAndSend(event);
            }
        }
    }

    @Override
    public void receive(Event[] events) {
        if (events != null) {
            for (Sink sink : this.sinks) {
                if (sink.getHandler() != null) {
                    sink.getHandler().handle(events);
                    continue;
                }
                sink.getMapper().mapAndSend(events);
            }
        }
    }
}

