/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.table;

import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.config.SiddhiQueryContext;
import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.event.stream.StreamEventFactory;
import io.siddhi.core.exception.ConnectionUnavailableException;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.executor.VariableExpressionExecutor;
import io.siddhi.core.query.processor.ProcessingMode;
import io.siddhi.core.table.CompiledUpdateSet;
import io.siddhi.core.table.InMemoryCompiledCondition;
import io.siddhi.core.table.InMemoryCompiledUpdateSet;
import io.siddhi.core.table.Table;
import io.siddhi.core.table.holder.EventHolder;
import io.siddhi.core.table.record.RecordTableHandler;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.CompiledCondition;
import io.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import io.siddhi.core.util.collection.operator.Operator;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.parser.EventHolderPasser;
import io.siddhi.core.util.parser.ExpressionParser;
import io.siddhi.core.util.parser.OperatorParser;
import io.siddhi.core.util.snapshot.state.SnapshotStateList;
import io.siddhi.core.util.snapshot.state.State;
import io.siddhi.core.util.snapshot.state.StateHolder;
import io.siddhi.query.api.definition.AbstractDefinition;
import io.siddhi.query.api.definition.TableDefinition;
import io.siddhi.query.api.execution.query.output.stream.UpdateSet;
import io.siddhi.query.api.expression.Expression;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InMemoryTable
extends Table {
    StreamEventCloner tableStreamEventCloner;
    ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    StateHolder<TableState> stateHolder;

    @Override
    public void init(TableDefinition tableDefinition, StreamEventFactory storeEventPool, StreamEventCloner storeEventCloner, ConfigReader configReader, SiddhiAppContext siddhiAppContext, RecordTableHandler recordTableHandler) {
        this.tableDefinition = tableDefinition;
        this.tableStreamEventCloner = storeEventCloner;
        EventHolder eventHolder = EventHolderPasser.parse((AbstractDefinition)tableDefinition, storeEventPool, siddhiAppContext, false);
        this.stateHolder = siddhiAppContext.generateStateHolder(tableDefinition.getId(), () -> new TableState(eventHolder));
    }

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }

    @Override
    public void add(ComplexEventChunk<StreamEvent> addingEventChunk) {
        this.readWriteLock.writeLock().lock();
        TableState state = this.stateHolder.getState();
        try {
            state.eventHolder.add(addingEventChunk);
        }
        finally {
            this.stateHolder.returnState(state);
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, CompiledCondition compiledCondition) {
        this.readWriteLock.writeLock().lock();
        TableState state = this.stateHolder.getState();
        try {
            ((Operator)((InMemoryCompiledCondition)compiledCondition).getOperatorCompiledCondition()).delete(deletingEventChunk, state.eventHolder);
        }
        finally {
            this.stateHolder.returnState(state);
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet) {
        this.readWriteLock.writeLock().lock();
        TableState state = this.stateHolder.getState();
        try {
            ((Operator)((InMemoryCompiledCondition)compiledCondition).getOperatorCompiledCondition()).update(updatingEventChunk, state.eventHolder, (InMemoryCompiledUpdateSet)compiledUpdateSet);
        }
        finally {
            this.stateHolder.returnState(state);
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateOrAdd(ComplexEventChunk<StateEvent> updateOrAddingEventChunk, CompiledCondition compiledCondition, CompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        this.readWriteLock.writeLock().lock();
        TableState state = this.stateHolder.getState();
        InMemoryCompiledCondition inMemoryCompiledCondition = (InMemoryCompiledCondition)compiledCondition;
        try {
            ComplexEventChunk<StateEvent> failedEvents = ((Operator)inMemoryCompiledCondition.getOperatorCompiledCondition()).tryUpdate(updateOrAddingEventChunk, state.eventHolder, (InMemoryCompiledUpdateSet)compiledUpdateSet, addingStreamEventExtractor);
            if (failedEvents != null && failedEvents.getFirst() != null) {
                state.eventHolder.add(this.reduceEventsForUpdateOrInsert(addingStreamEventExtractor, inMemoryCompiledCondition, (InMemoryCompiledUpdateSet)compiledUpdateSet, failedEvents));
            }
        }
        finally {
            this.stateHolder.returnState(state);
            this.readWriteLock.writeLock().unlock();
        }
    }

    protected ComplexEventChunk<StreamEvent> reduceEventsForUpdateOrInsert(AddingStreamEventExtractor addingStreamEventExtractor, InMemoryCompiledCondition inMemoryCompiledCondition, InMemoryCompiledUpdateSet compiledUpdateSet, ComplexEventChunk<StateEvent> failedEvents) {
        ComplexEventChunk<StreamEvent> toInsertEventChunk = new ComplexEventChunk<StreamEvent>(failedEvents.isBatch());
        failedEvents.reset();
        while (failedEvents.hasNext()) {
            StateEvent failedEvent = (StateEvent)failedEvents.next();
            boolean updated = false;
            toInsertEventChunk.reset();
            while (toInsertEventChunk.hasNext()) {
                StreamEvent toInsertEvent = (StreamEvent)toInsertEventChunk.next();
                failedEvent.setEvent(inMemoryCompiledCondition.getStoreEventIndex(), toInsertEvent);
                if (!((Boolean)inMemoryCompiledCondition.getUpdateOrInsertExpressionExecutor().execute(failedEvent)).booleanValue()) continue;
                for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                    toInsertEvent.setOutputData(entry.getValue().execute(failedEvent), entry.getKey());
                }
                updated = true;
            }
            if (updated) continue;
            toInsertEventChunk.add(addingStreamEventExtractor.getAddingStreamEvent(failedEvent));
        }
        return toInsertEventChunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        this.readWriteLock.readLock().lock();
        TableState state = this.stateHolder.getState();
        try {
            boolean bl = ((Operator)((InMemoryCompiledCondition)compiledCondition).getOperatorCompiledCondition()).contains(matchingEvent, state.eventHolder);
            return bl;
        }
        finally {
            this.stateHolder.returnState(state);
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    protected void disconnect() {
    }

    @Override
    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamEvent find(CompiledCondition compiledCondition, StateEvent matchingEvent) {
        TableState state = this.stateHolder.getState();
        this.readWriteLock.readLock().lock();
        try {
            StreamEvent streamEvent = ((Operator)((InMemoryCompiledCondition)compiledCondition).getOperatorCompiledCondition()).find(matchingEvent, state.eventHolder, this.tableStreamEventCloner);
            return streamEvent;
        }
        finally {
            this.stateHolder.returnState(state);
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        TableState state = this.stateHolder.getState();
        try {
            InMemoryCompiledCondition inMemoryCompiledCondition = new InMemoryCompiledCondition(OperatorParser.constructOperator(state.eventHolder, condition, matchingMetaInfoHolder, variableExpressionExecutors, tableMap, siddhiQueryContext), ExpressionParser.parseExpression(condition, matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext), matchingMetaInfoHolder.getStoreEventIndex());
            return inMemoryCompiledCondition;
        }
        finally {
            this.stateHolder.returnState(state);
        }
    }

    @Override
    public CompiledUpdateSet compileUpdateSet(UpdateSet updateSet, MatchingMetaInfoHolder matchingMetaInfoHolder, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, SiddhiQueryContext siddhiQueryContext) {
        HashMap<Integer, ExpressionExecutor> expressionExecutorMap = new HashMap<Integer, ExpressionExecutor>();
        for (UpdateSet.SetAttribute setAttribute : updateSet.getSetAttributeList()) {
            ExpressionExecutor expressionExecutor = ExpressionParser.parseExpression(setAttribute.getAssignmentExpression(), matchingMetaInfoHolder.getMetaStateEvent(), matchingMetaInfoHolder.getCurrentState(), tableMap, variableExpressionExecutors, false, 0, ProcessingMode.BATCH, false, siddhiQueryContext);
            int attributePosition = this.tableDefinition.getAttributePosition(setAttribute.getTableVariable().getAttributeName());
            expressionExecutorMap.put(attributePosition, expressionExecutor);
        }
        return new InMemoryCompiledUpdateSet(expressionExecutorMap);
    }

    @Override
    protected void connectAndLoadCache() throws ConnectionUnavailableException {
    }

    public int size() {
        return this.stateHolder.getState().eventHolder.size();
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    public class TableState
    extends State {
        private final EventHolder eventHolder;

        public TableState(EventHolder eventHolder) {
            this.eventHolder = eventHolder;
        }

        public EventHolder getEventHolder() {
            return this.eventHolder;
        }

        @Override
        public boolean canDestroy() {
            return false;
        }

        @Override
        public Map<String, Object> snapshot() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            state.put("EventHolder", this.eventHolder.getSnapshot());
            return state;
        }

        @Override
        public void restore(Map<String, Object> state) {
            this.eventHolder.restore((SnapshotStateList)state.get("EventHolder"));
        }
    }
}

