/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util;

import io.siddhi.core.exception.CannotLoadClassException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.util.extension.holder.AbstractExtensionHolder;
import io.siddhi.query.api.extension.Extension;

public class SiddhiClassLoader {
    private static Object loadClass(Class clazz) throws CannotLoadClassException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new CannotLoadClassException("Cannot restore class: " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new CannotLoadClassException("Cannot restore class: " + clazz.getName(), e);
        }
    }

    public static Object loadExtensionImplementation(Extension extension, AbstractExtensionHolder extensionHolder) {
        Class clazz = extensionHolder.getExtension(extension.getNamespace(), extension.getName());
        if (clazz == null) {
            throw new SiddhiAppCreationException("No extension exist for " + extension.getNamespace() + ":" + extension.getName(), true);
        }
        try {
            return SiddhiClassLoader.loadClass(clazz);
        }
        catch (CannotLoadClassException e) {
            throw new SiddhiAppCreationException("Extension " + clazz.getName() + " cannot be loaded!", true);
        }
    }
}

