/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.core.util.collection.operator;

import io.siddhi.core.event.ComplexEventChunk;
import io.siddhi.core.event.state.StateEvent;
import io.siddhi.core.event.stream.StreamEvent;
import io.siddhi.core.event.stream.StreamEventCloner;
import io.siddhi.core.executor.ExpressionExecutor;
import io.siddhi.core.table.InMemoryCompiledUpdateSet;
import io.siddhi.core.util.collection.AddingStreamEventExtractor;
import io.siddhi.core.util.collection.operator.Operator;
import java.util.Map;

public class EventChunkOperator
implements Operator {
    protected ExpressionExecutor expressionExecutor;
    protected int storeEventPosition;

    public EventChunkOperator(ExpressionExecutor expressionExecutor, int storeEventPosition) {
        this.expressionExecutor = expressionExecutor;
        this.storeEventPosition = storeEventPosition;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object storeEvents, StreamEventCloner storeEventCloner) {
        ComplexEventChunk storeEventChunk = (ComplexEventChunk)storeEvents;
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        storeEventChunk.reset();
        while (storeEventChunk.hasNext()) {
            StreamEvent storeEvent = (StreamEvent)storeEventChunk.next();
            matchingEvent.setEvent(this.storeEventPosition, storeEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
            }
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, Object storeEvents) {
        ComplexEventChunk storeEventChunk = (ComplexEventChunk)storeEvents;
        try {
            storeEventChunk.reset();
            while (storeEventChunk.hasNext()) {
                StreamEvent storeEvent = (StreamEvent)storeEventChunk.next();
                matchingEvent.setEvent(this.storeEventPosition, storeEvent);
                if (!((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object storeEvents) {
        ComplexEventChunk storeEventChunk = (ComplexEventChunk)storeEvents;
        deletingEventChunk.reset();
        while (deletingEventChunk.hasNext()) {
            StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
            try {
                storeEventChunk.reset();
                while (storeEventChunk.hasNext()) {
                    StreamEvent storeEvent = (StreamEvent)storeEventChunk.next();
                    deletingEvent.setEvent(this.storeEventPosition, storeEvent);
                    if (!((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) continue;
                    storeEventChunk.remove();
                }
            }
            finally {
                deletingEvent.setEvent(this.storeEventPosition, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet) {
        ComplexEventChunk storeEventChunk = (ComplexEventChunk)storeEvents;
        updatingEventChunk.reset();
        while (updatingEventChunk.hasNext()) {
            StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
            try {
                storeEventChunk.reset();
                while (storeEventChunk.hasNext()) {
                    StreamEvent storeEvent = (StreamEvent)storeEventChunk.next();
                    updatingEvent.setEvent(this.storeEventPosition, storeEvent);
                    if (!((Boolean)this.expressionExecutor.execute(updatingEvent)).booleanValue()) continue;
                    for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                        storeEvent.setOutputData(entry.getValue().execute(updatingEvent), entry.getKey());
                    }
                }
            }
            finally {
                updatingEvent.setEvent(this.storeEventPosition, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> tryUpdate(ComplexEventChunk<StateEvent> updatingOrAddingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        ComplexEventChunk storeEventChunk = (ComplexEventChunk)storeEvents;
        updatingOrAddingEventChunk.reset();
        ComplexEventChunk<StateEvent> failedEventChunk = new ComplexEventChunk<StateEvent>(updatingOrAddingEventChunk.isBatch());
        while (updatingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)updatingOrAddingEventChunk.next();
            try {
                boolean updated = false;
                storeEventChunk.reset();
                while (storeEventChunk.hasNext()) {
                    StreamEvent storeEvent = (StreamEvent)storeEventChunk.next();
                    overwritingOrAddingEvent.setEvent(this.storeEventPosition, storeEvent);
                    if (!((Boolean)this.expressionExecutor.execute(overwritingOrAddingEvent)).booleanValue()) continue;
                    for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                        storeEvent.setOutputData(entry.getValue().execute(overwritingOrAddingEvent), entry.getKey());
                    }
                    updated = true;
                }
                if (updated) continue;
                updatingOrAddingEventChunk.remove();
                failedEventChunk.add(overwritingOrAddingEvent);
            }
            finally {
                overwritingOrAddingEvent.setEvent(this.storeEventPosition, null);
            }
        }
        return failedEventChunk;
    }
}

