/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.doc.gen.extensions.githubclient;

import io.siddhi.doc.gen.extensions.githubclient.ContentsBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;

public abstract class ContentsResponse<T> {
    final InputStream stream;
    private final int status;
    private final Map<String, List<String>> headers;
    ContentsBodyReader contentsBodyReader;

    ContentsResponse(HttpsURLConnection connection) throws IOException {
        connection.setRequestProperty("Accept", "application/vnd.githubclient.v3." + this.mediaType());
        this.status = connection.getResponseCode();
        this.stream = this.status == 200 ? connection.getInputStream() : connection.getErrorStream();
        this.headers = connection.getHeaderFields();
        this.contentsBodyReader = null;
    }

    abstract String mediaType();

    public abstract T getContent() throws IOException;

    public List<String> getHeader(String name) {
        return this.headers.get(name);
    }

    public ContentsBodyReader getContentsBodyReader() {
        if (this.contentsBodyReader == null) {
            throw new IllegalStateException(this.getClass().getCanonicalName() + " does not implement a subclass of " + ContentsBodyReader.class.getCanonicalName());
        }
        return this.contentsBodyReader;
    }

    public JSONObject getError() throws IOException {
        if (this.status == 200) {
            throw new IllegalStateException("Response does not contain an error.");
        }
        if (this.stream == null) {
            return new JSONObject();
        }
        return new JSONObject(IOUtils.toString((InputStream)this.stream, (String)"UTF-8"));
    }

    public int getStatus() {
        return this.status;
    }
}

